﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Text.Json;
using System.Text.Json.Serialization;

using RestSharp;

namespace iStatVball3;

/*
 * Encapsulates the REST response returned from MaxPreps API calls.
 */
public class MP2Response
{
    /* Constants */
    public const int Success = 200;

	/* Properties */
	[JsonPropertyName("status")] public int Status { get; set; }

    [JsonPropertyName("message")] public string Message { get; set; }
    [JsonPropertyName("cacheResult")] public string CacheResult { get; set; }
    [JsonPropertyName("data")] public MP2ResponseData Data { get; set; }

    [JsonPropertyName("warnings")] public IList<string> Warnings { get; set; }
    [JsonPropertyName("errors")] public IList<string> Errors { get; set; }

    /* Methods */

    // Deserializes REST response content into MaxPreps object
    public static MP2Response Deserialize( RestResponse response )
    {
        string content = response.Content;

        return (content == null) ? null : JsonSerializer.Deserialize<MP2Response>( content );
    }

    /*
     * Encapsulates inner fields of the response 'data' field.
     */
    public class MP2ResponseData
    {
	    [JsonPropertyName("message")] public string Message { get; set; }
	    [JsonPropertyName("contestId")] public string ContestId { get; set; }
    }
}

//
