﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Text.Json.Serialization;

namespace iStatVball3;

/*
 * Represents one MaxPreps player and their associated stats for one match.
 */
public class MP2Athlete
{
    /* Properties */

    [JsonPropertyName("firstname")] public string FirstName { get; set; }
    [JsonPropertyName("lastname")] public string LastName { get; set; }

    [JsonPropertyName("jersey")] public string Jersey { get; set; }
    [JsonPropertyName("classyear")] public int ClassYear { get; set; }

    [JsonPropertyName("stats")] public IList<MP2Stat> Stats { get; set; }

    /* Methods */
	public MP2Athlete( DataMetrics metrics )
	{
        if ( metrics.TypeObject is Player player )
        {
            // Base fields
            FirstName = player.FirstName;
            LastName = player.LastName;
            Jersey = player.Number;
            ClassYear = GetYear( player );
        }

        // All match stats
        Stats = GetStats( metrics );
    }

    // Maps player year in school to MaxPreps value
    private static int GetYear( Player player )
    {
        if ( player.Year != null )
        {
            return player.Year switch
            {
                "senior" => 12,
                "junior" => 11,
                "soph" => 10,
                "frosh" => 9,

                _ => 0
            };
        }

        return 0;
    }

    // Returns list of all match stats for this player
    private static List<MP2Stat> GetStats( DataMetrics metrics )
    {
        List<MP2Stat> stats = [];

        if ( metrics is MetricsSkill skills )
        {
            stats.Add( new MP2Stat( "MatchGamesPlayed", skills.SetsPlayed ) );

            // Serve
            stats.Add( new MP2Stat( "TotalServes", skills.Serve_Attempts ) );
            stats.Add( new MP2Stat( "ServingAces", skills.Serve_Aces ) );
            stats.Add( new MP2Stat( "ServingErrors", skills.Serve_Errors ) );
            stats.Add( new MP2Stat( "ServingPoints", skills.Serve_Points ) );

            // Attack
            stats.Add( new MP2Stat( "AttacksAttempts", skills.Attack_TotalAttempts ) );
            stats.Add( new MP2Stat( "AttacksKills", skills.Attack_TotalKills ) );
            stats.Add( new MP2Stat( "AttacksErrors", skills.Attack_TotalErrors ) );

            int receiveSuccess = (skills.Receive_Attempts - skills.Receive_Errors);

            // Receive
            stats.Add( new MP2Stat( "ServingReceivedSuccess", receiveSuccess ) );
            stats.Add( new MP2Stat( "ServingReceivedErrors", skills.Receive_Errors ) );

            // Block
            stats.Add( new MP2Stat( "BlocksSolo", skills.Block_Blocks ) );
            stats.Add( new MP2Stat( "BlocksAssists", skills.Block_Assists ) );
            stats.Add( new MP2Stat( "BlocksErrors", skills.Block_Errors ) );

            // Set
            stats.Add( new MP2Stat( "BallHandlingAttempt", skills.Set_Attempts ) );
            stats.Add( new MP2Stat( "Assists", skills.Set_TotalAssists ) );
            stats.Add( new MP2Stat( "AssistsErrors", skills.Set_Errors ) );

            // Defense
            stats.Add( new MP2Stat( "Digs", skills.Defense_Digs ) );
            stats.Add( new MP2Stat( "DigsErrors", skills.Defense_Errors ) );
        }

        return stats;
    }
}

//
