﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Displays information for an individual MaxPreps school. Used both in the school selection list and the removal tool.
 */ 
public class MP2SchoolView : DXGridLayout
{
    /* Constants */
    private const double DefaultViewWd = 465;
    private const double DefaultViewHt = 80;

    /* Properties */
    public static double ViewWd => Math.Min( DefaultViewWd, DXDevice.GetScreenWd() );
    public static double ViewHt => DefaultViewHt;

    /* Fields */
    private readonly DXLabel nameLbl;
    private readonly DXLabel mascotLbl;
    private readonly DXLabel addressLbl;

    private readonly DXLine divider;

    /* Methods */
	public MP2SchoolView()
	{
		BackgroundColor = DXColors.Light4;

		Padding = new Thickness( 0, 10 );
		Margin = 0;

        RowSpacing = 2;
        ColumnSpacing = 0;

        Horizontal = LayoutOptions.Fill;
        Vertical = LayoutOptions.Fill;

        IsClippedToBounds = true;
        
        // Name
        nameLbl = new DXLabel
        {
            TextColor = DXColors.Dark1,

            Font = DXFonts.RobotoBold,
            FontSize = 17,

            LineBreakMode = LineBreakMode.TailTruncation,
            Padding = 0,

            Horizontal = LayoutOptions.Start,
            Vertical = LayoutOptions.Start
        };

        nameLbl.SetBinding( Label.TextProperty, "Name" );

        // Mascot
        mascotLbl = new DXLabel
        {
            TextColor = DXColors.Dark3,

            Font = DXFonts.RobotoItalic,
            FontSize = 14,

            LineBreakMode = LineBreakMode.TailTruncation,
            Padding = 0,

            Horizontal = LayoutOptions.Start,
            Vertical = LayoutOptions.Center
        };

        mascotLbl.SetBinding( Label.TextProperty, "Mascot" );

        // Address
        addressLbl = new DXLabel
        {
            TextColor = DXColors.Dark4,

            Font = DXFonts.Roboto,
            FontSize = 12,

            LineBreakMode = LineBreakMode.TailTruncation,
            Padding = 0,

            Horizontal = LayoutOptions.Start,
            Vertical = LayoutOptions.Center
        };

        addressLbl.SetBinding( Label.TextProperty, "FullAddress" );

        // Row divider
        divider = new DXLine
        {
            Color = DXColors.Light1,
            Thickness = 1,
            WidthRequest = ViewWd,

            Horizontal = LayoutOptions.Fill,
            Vertical = LayoutOptions.End
        };

        // 3 columns
        AddFixedColumn( 10 );           // 0: pad
        AddStarColumn();                // 1: content
        AddFixedColumn( 10 );           // 2: pad

        // 4 rows
        AddFixedRow( 20 );              // 0: name
        AddFixedRow( 19 );              // 1: mascot
        AddFixedRow( 19 );              // 2: address
        AddFixedRow( 5 );               // 3: divider

        // Add components
        Add( nameLbl, 1, 0 );
        Add( mascotLbl, 1, 1 );
        Add( addressLbl, 1, 2 );
        Add( divider, 0, 3, 3, 1 );
    }

    // Initializes view with specified school
    public MP2SchoolView( MP2School school ) : this()
    {
        nameLbl.Text = school.Name;
        mascotLbl.Text = school.Mascot;
        addressLbl.Text = school.FullAddress;

        divider.IsVisible = false;
    }
}

//
