﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Form;
using DXLib.UI.Alert;

using DXLib.UI.Control;
using DXLib.UI.Control.Button;

namespace iStatVball3;

/*
 * Utility class for handling MaxPreps related interface functionality including school link selection and removal.
 */
public class MP2Interface
{
    /* Properties */
    public DXForm Form { get; set; }
    public MP2School School { get; set; }

    public bool IsHighSchool { get; set; }
    public bool HasSchool => School != null;
    public bool HasChanges { get; private set; }

    /* Fields */
    private MP2Selector selector;
    private MP2Remover remover;

    /* Methods */

    // Add link button to form header
    public void UpdateHeader()
    {
        Form.CustomHeader = IsHighSchool ? "maxpreps" : null;
        Form.CustomHeaderColor = HasSchool ? DXColors.Negative : DXColors.Dark1;
    }

    // Shows either link selection or removal interface based on state
    public async Task Show()
    {
        DXIconButton btn = Form.CustomHeaderBtn;

        // No link yet, show selector
        if ( School == null )
        {
            DXSpinner.Start();

            selector = new MP2Selector
            {
                Selected = OnSchoolSelected,
                PopupClosed = btn.Reset
            };

            await selector.Init();
            selector.ShowFromView( btn );

            DXSpinner.Stop();
        }
        // Existing link, show remover
        else
        {
            remover = new MP2Remover( School )
            {
                Removed = OnSchoolRemoved,
                PopupClosed = btn.Reset
            };

            remover.Init();
            remover.ShowFromView( btn, -50, 0 );
        }
    }

    // User selected school to link
    private void OnSchoolSelected( MP2School school )
    {
        School = school;

        selector.Hide();

        UpdateHeader();

        HasChanges = true;
        Form.UpdateSave();

        DXAlert.ShowOk( "maxpreps2.title", "maxpreps2.link", school.Name );
    }

    // User removed school link
    private void OnSchoolRemoved()
    {
        School = null;

        remover.Hide();

        UpdateHeader();

        HasChanges = true;
        Form.UpdateSave();
    }
}

//
