﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Used to serialize an individual Match into Bound JSON format.
 */
public class VBMatch
{
	/* Properties */

	// Match metadata
	public string UniqueId { get; set; }
	public string Date { get; set; }

	public string Team1 { get; set; }
	public string Team2 { get; set; }

	public string Result { get; set; }

	public int Sets1 { get; set; }
	public int Sets2 { get; set; }

	public IList<int> Scores1 { get; set; }
	public IList<int> Scores2 { get; set; }

	// Team roster
	public IList<VBPlayer> Roster { get; set; }

	// Starting lineup
	public IList<string> Lineup { get; set; }

	// Player stats
	public IList<VBStats> Stats { get; set; }
}

//
