﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.Utils;

namespace iStatVball3;

/*
 * Defines layout for all small size cards (third column/row) on the Season Home page.
 */ 
public class HomeCardSmall : HomeCard
{
	/* Constants */
	public const double CardHt = 150;
	
	/* Properties */
	public string ImageUrl { set => imageArea.SetImage( value ); }

	/* Methods */
	public HomeCardSmall()
	{
		// Widescreen requires separate layout, all others same
		bool wide = DXDevice.IsTabletWide;

		labels.TitleLbl.FontSize = 18;

		// 2 rows
		layout.AddStarRow( wide ? 65 : 50 );	// 0: labels
		layout.AddStarRow( wide ? 35 : 50 );	// 1: fill

		// 2 columns
		layout.AddStarColumn( 60 );				// 0: labels
		layout.AddStarColumn( 40 );				// 1: image

		// Add components
		layout.Add( labels, 0, 0 );
		layout.Add( imageArea, 1, 0, 1, 2 );
	}
}

//
