﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Control;
using DXLib.UI.Control.Badge;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Defines layout for all medium size cards (second column/row) on the Season Home page.
 */
public class HomeCardMedium : HomeCard
{
	/* Constants */
	public const double CardHt = 200;
	
	/* Fields */
	private readonly DXTextBadge badge;
	private readonly DXLabel recordLbl;

	/* Methods */
	public HomeCardMedium()
	{
		bool ios = DXDevice.IsIOS;
		bool tablet = DXDevice.IsTablet;

		labels.TitleLbl.FontSize = 22;

		// Badge
		badge = new DXTextBadge
		{
			IsVisible = false,

			FontSize = 12,
			Color = DXColors.Dark4,
			TextColor = DXColors.Light4,

			Margin = new Thickness( 10, 0 ),

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Start
		};

		// Record
		recordLbl = new DXLabel
		{
			IsVisible = false,

			TextColor = DXColors.Dark4,
			Font = DXFonts.Oswald,
			FontSize = 42,

			Margin = new Thickness( 10, (ios ? 0 : -15), 10, 15 ),

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Start
		};

		// 4 rows
		layout.AddStarRow( tablet ? 40 : 60 );		// 0: labels
		layout.AddStarRow( tablet ? 60 : 40 );		// 1: fill
		layout.AddFixedRow( 22 );					// 2: badge
		layout.AddFixedRow( ios ? 55 : 65 );		// 3: record

		// 2 columns
		layout.AddStarColumn( 60 );					// 0: labels
		layout.AddStarColumn( 40 );					// 1: image

		layout.Add( imageArea, 1, 0, 1, 4 );
		layout.Add( labels, 0, 0 );

		layout.Add( badge, 0, 2 );
		layout.Add( recordLbl, 0, 3 );
	}

	// Updates 'win-loss-tie' record label
	public void UpdateRecord( Season season )
	{
		int won = season.Won;
		int lost = season.Lost;
		int tied = season.Tied;

		if ( (won + lost + tied) > 0 )
		{
			badge.Text = DXString.GetUpper( "home.record" );
			badge.IsVisible = true;

			// 'X-Y'
			string record = $"{won}-{lost}";

			// Only show ties if they exist
			if ( tied > 0 )
			{
				record += $"-{tied}";
			}

			recordLbl.Text = record;
			recordLbl.IsVisible = true;
		}
	}
}

//
