﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Card;
using DXLib.UI.Control.Image;

namespace iStatVball3;

/*
 * Base class for all cards on the Season Home page. These cards differ from the standard cards used on card pages
 * elsewhere in the UI.
 */ 
public class HomeCard : DXCard
{
	/* Properties */
	public string DefaultIcon { set { imageArea.DefaultIcon = value; imageArea.SetImage( (byte[])null ); } }
	public byte[] Image { set => imageArea.SetImage( value ); }

	// Custom color
	public virtual Color ImageColor { set => imageArea.Color = value; }

	public string Title { set => labels.Title = value; }
	public string SubTitle { set => labels.SubTitle = value; }

	/* Fields */
	protected readonly DXImageArea imageArea;
	protected readonly DXCardLabels labels;

	/* Methods */
	protected HomeCard()
	{
		layout.RowSpacing = 0;
		layout.ColumnSpacing = 0;
		
		// Icon/Photo
		imageArea = new DXImageArea();

		// Title/Subtitle
		labels = new DXCardLabels
		{
			SubTitleLbl = { Font = DXFonts.Roboto }
		};
	}
}

//
