﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Control;
using DXLib.UI.Layout;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Implements a header view for the EditTallyForm showing the set number and the name of the currently selected player.
 */
public class EditTallyHeader : DXHorizontalLayout
{
	/* Fields */
	private readonly DXLabel setLbl;
	private readonly DXLabel playerLbl;

	/* Methods */
	public EditTallyHeader()
	{
		BackgroundColor = DXColors.Light2;

		// Layout
		Padding = new Thickness( 15, 0 );
		Spacing = 15;

		Horizontal = LayoutOptions.Fill;
		Vertical = LayoutOptions.Fill;

		IgnoreSafeArea = true;
		
		// Set number
		setLbl = new DXLabel
		{
			TextColor = DXColors.Dark1,
			Font = DXFonts.RobotoBold,
			FontSize = 24,

			VAlign = TextAlignment.Center,
			Vertical = LayoutOptions.Center
		};

		Add( setLbl );

		// Player name
		playerLbl = new DXLabel
		{
			TextColor = DXColors.Dark1,
			FontResource = DXFonts.Roboto,
			FontSize = 20,

			VAlign = TextAlignment.Center,
			Vertical = LayoutOptions.Center
		};

		Add( playerLbl );
	}

	// Post construction initialization
	public void Init( Set set )
	{
		string setStr = DXString.Get( "set.singular" );
		string numStr = set.Number.ToString();

		// 'Set N'
		setLbl.Text = $"{setStr} {numStr}";
	}

	// Updates player name
	public void SetPlayer( Player player )
	{
		playerLbl.Text = player.FullName;
	}
}

//
