﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control;

namespace iStatVball3;

/*
 * Implements a simple view for displaying debug information for an EditTallyCell including the metrics value, summary
 * adjustment, and then the combined total.
 */
public class EditTallyDebug : DXGridLayout
{
	/* Fields */
	private readonly DXLabel metricValue;
	private readonly DXLabel summaryValue;
	private readonly DXLabel totalValue;

	/* Methods */
	public EditTallyDebug()
	{
		Padding = 10;
		RowSpacing = 5;
		ColumnSpacing = 20;

		// Headers
		DXLabel metricHeader = CreateHeader( "tally.raw" );
		DXLabel summaryHeader = CreateHeader( "tally.adjust" );
		DXLabel totalHeader = CreateHeader( "tally.total" );

		// Value labels
		metricValue = CreateValue();
		summaryValue = CreateValue();
		totalValue = CreateValue();

		// 4 rows
		AddStarRow( 33 );			// 0: metric
		AddStarRow( 33 );			// 1: summary
		AddFixedRow( 1 );			// 2: divider
		AddStarRow( 33 );			// 3: total

		// 2 columns
		AddStarColumn( 70 );		// 0: header
		AddStarColumn( 30 );		// 1: value

		Add( metricHeader, 0, 0 );
		Add( summaryHeader, 0, 1 );
		Add( totalHeader, 0, 3 );

		Add( metricValue, 1, 0 );
		Add( summaryValue, 1, 1 );
		Add( totalValue, 1, 3 );

		Fill( DXColors.Dark1, 0, 2, 2, 1 );
	}

	// Initializes debug with specified values
	public void Init( int metrics, int summary )
	{
		int total = (metrics + summary);

		metricValue.Text = metrics.ToString();
		summaryValue.Text = summary.ToString();
		totalValue.Text = total.ToString();
	}

	// Creates header label
	private static DXLabel CreateHeader( string resource )
	{
		return new DXLabel
		{
			Resource = resource,

			TextColor = DXColors.Dark1,
			Font = DXFonts.RobotoBold,
			FontSize = 17,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};
	}

	// Creates value label
	private static DXLabel CreateValue()
	{
		return new DXLabel
		{
			TextColor = DXColors.Dark1,
			Font = DXFonts.Roboto,
			FontSize = 17,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center
		};
	}
}

//
