﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using System.Globalization;
using Syncfusion.Licensing;

using DXLib.UI.Control;

using DXLib.Log;
using DXLib.Data;
using DXLib.Utils;

namespace iStatVball3;

/*
 * Main app entry point. Performs initialization and displays UI shell.
 */
public class App : Application
{
	/* Constants */

	// App major.minor.micro version for display purposes only
	public const string AppVersion = "3.20.7";

	/* Methods */
	public App()
	{
																														DXProfiler.Start( true );
		// Init language settings
		InitCulture();
		
		// Must be done first
		SyncfusionLicenseProvider.RegisterLicense( LicenseKey );
																														DXProfiler.Mark( "License" );
		// Load static strings
		DXString.Init( Strings_EN.Load() );
		DXTooltip.Init( Tooltips_EN.Load() );
																														DXProfiler.Mark( "Strings" );
		// Init device info
		DXDevice.Init();
																														DXProfiler.Mark( "Device" );
		// Init resource paths
		DXResource.Init( typeof(App) );
																														DXProfiler.Mark( "Rsrc" );
		// Init SkiaSharp graphics
		_ = DXGraphics.Init();
																														DXProfiler.Mark( "Skia" );
		// Init Firestore and MonkeyBarrel
		DXData.Init( "istatvball3" );
																														DXProfiler.Mark( "Data" );
		// Listen for orientation changes
		DeviceDisplay.MainDisplayInfoChanged += ( sender, args ) =>
		{
			DXLog.Debug( "OrientationChanged" );

			UpdateLayout();
		};

		// Jump directly into app if login cached, else start login flow
		_ = LaunchStack.Launch();
	}

	// Initializes global culture settings to 'en-US'
	private static void InitCulture()
	{
		CultureInfo info = new( "en-US" );
		
		// Text formatting
		CultureInfo.CurrentCulture = info;
		CultureInfo.CurrentUICulture = info;
		
		NumberFormatInfo format = info.NumberFormat;
		
		// Number formatting
		format.PercentPositivePattern = 1;
		format.NaNSymbol = DXData.NaN;
	}
	
	// Creates master window for entire app, replaces MainPage
	protected override Window CreateWindow( IActivationState state )
	{
		DXLog.Debug( "Create" );
		
		// Create singleton app shell
		Shell shell = Shell.Instance;
																														DXProfiler.Mark( "Shell" );
		return new Window( shell );
	}

	// Called once-only at launch
	protected override void OnStart()
	{
		DXLog.Debug( "Start" );
	}

	// Called when returning from background
	protected override void OnResume()
	{
		DXLog.Debug( "Resume" );
	}

	// Layout based on orientation and screen size
	private static void UpdateLayout()
	{
		LayoutType type = DXDevice.GetLayoutType();

		DXLog.Debug( "Update:{0}", type );

		Shell shell = Shell.Instance;

		// Force redraw of entire UI stack
		shell.UpdateLayout( type );

		// Allow any rotation specific handling
		shell.Rotate();
	}

	// Syncfusion
	private const string LicenseKey = "Ngo9BigBOggjHTQxAR8/V1JFaF5cXGRCf1FpRmJGdld5fUVHYVZUTXxaS00DNHVRdkdmWXZcc3VTRWhZU0V+WEVWYEg=";
}

//
