﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Encapsulates all fields necessary to initialize a report analysis form.
 */
public class ReportConfig
{
	/* Properties */
	public string Title { get; set; }

	public string Scope { get; set; }
	public string ScopeName { get; set; }
	public object ScopeObject { get; set; }

	public Organization Organization { get; set; }
	public bool IsTeam1 { get; set; }

	public Team Team1 { get; set; }
	public Opponent Team2 { get; set; }

	// Eligible for live stats reload?
	public bool HasSync { get; set; }

	// Corresponding JSON config
	public JsonDashboard Dashboard { get; set; }

	// Inner dimension enabled?
	public bool HasInner => Dashboard.Inner;

	// Represents a custom form?
	public bool IsCustom => Dashboard.IsCustom;

	// Unique report identifier
	public string Key => Dashboard.Key;

	/* Methods */

	// Returns data set for all reports on dashboard (non-custom only)
	public string GetDataSet()
	{
		return GetFirstReport()?.Data;
	}

	// Returns action for all reports on dashboard (non-custom only)
	public string GetAction()
	{
		return GetFirstReport()?.Action;
	}

	// Returns first report from dashboard
	private JsonReport GetFirstReport()
	{
		IList<JsonReport> reports = Dashboard.Reports;

		return (reports.Count > 0) ? reports[0] : null;
	}
}

//
