﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.Utils;

namespace iStatVball3;

/*
 * Report card for the Momentum Chart report type. Contains a report header and momentum chart.
 */
public class MomentumCard : ReportCard
{
	/* Properties */

	// External access required for PDF export
	public MomentumView View { get; private set; }

	/* Fields */
	private MomentumChart chart;

	/* Methods */
	public MomentumCard( JsonReport json, string dimension ) : base( json, dimension )
	{}

	// Post construction initialization
	public override void Init()
	{
		// No extra header button
		Options = null;

		base.Init();

		// Underlying control
		View = new MomentumView
		{
			Margin = new Thickness( (Pad - 10), 10, (Pad + 5), Pad )
		};

		layout.Add( View, 1, 1 );

		// Helper class
		chart = new MomentumChart
		{
			View = View
		};

		// Setup chart
		View.Init();
	}

	// Updates all data displayed on this card
	public override async Task UpdateData( DataConfig config )
	{
		await base.UpdateData( config );

		// Update underlying control			
		chart.UpdateData( config, stats );

		// Required to stop spinner
		OnLoadComplete();
	}

	/* Layout */

	// Redraws entire report card
	public override void UpdateLayout( LayoutType type )
	{
		base.UpdateLayout( type );

		// WORKAROUND: MAUI issues
		switch ( type )
		{
			case LayoutType.MobilePortrait:
			{
				View.Margin = new Thickness( Pad, 10, Pad, Pad );
				break;
			}
			case LayoutType.MobileLandscape:
			{
				double safe = DXDevice.SafeArea().Left;

				View.Margin = new Thickness( (safe + Pad), 10, (safe + Pad), Pad );
				break;
			}
		}

		// Update children
		View.UpdateLayout( type );
	}
}

//
