﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Used for JSON deserialization of the configuration for an individual data report on a dashboard. Because of the
 * limitations of inheritance in JSON deserialization, this class represents all possible report types.
 */
public class JsonReport
{
	/* Properties */

	// Grid, bar, etc
	public string Type { get; set; }

	// Unique identifier
	public string Key { get; set; }

	// Skills, scoring, etc
	public string Data { get; set; }

	// Attack, serve, etc
	public string Action { get; set; }

	// Display name
	public string Title { get; set; }

	// Tooltip text
	public string Help { get; set; }

	// Disable report for debug?
	public bool Hidden { get; set; }

	// Excluded dimensions
	public IList<string> Excludes { get; set; }

	// Custom Report metric config
	public JsonCustom Custom { get; set; }
	public bool HasCustom => Custom != null;

	// Mutually exclusive fields for each report type
	public JsonGrid Grid { get; set; }
	public JsonBar Bar { get; set; }
	public JsonShot Shot { get; set; }
	public JsonHeat Heat { get; set; }
	public JsonTrend Trend { get; set; }
	public JsonMomentum Momentum { get; set; }

	/* Methods */

	// Determines if this report visible and not excluded based on dimension
	public bool IsValid( DataConfig config )
	{
		return !Hidden && ((Excludes == null) || !Excludes.Contains( config.OuterDim ));
	}
}

//
