﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Text.Json.Serialization;

namespace iStatVball3;

/*
 * Used for JSON deserialization of the configuration for an individual dashboard category. A dashboard contains a list
 * of reports.
 */
public class JsonDashboard
{
	/* Constants */
	public const string BlockingKey = "blocking";
	public const string DefenseKey = "defense";
	public const string HittingKey = "hitting";
	public const string PassingKey = "passing";
	public const string ReceiveKey = "receive";
	public const string ServingKey = "serving";
	public const string SettingKey = "setting";

	/* Properties */
	public string Title { get; set; }
	public string Key { get; set; }

	public int Teams { get; set; }

	public List<string> Types { get; set; }
	public List<string> Dimensions { get; set; }

	public bool Inner { get; set; }

	// PDF export configuration
	public JsonDashboardPdf PDF { get; set; }

	// Underlying reports
	public IList<JsonReport> Reports { get; set; }

	/* Ignored */
	[JsonIgnore] public bool IsPdfEnabled => PDF is { Enabled: true };
	[JsonIgnore] public bool IsCustom { get; set; }

	// CUSTOM ONLY: Stores pre-configured dimension for each report
	[JsonIgnore] public List<string> CustomDimensions { get; set; }

	/* Methods */
	public JsonDashboard()
	{
		// Allocate containers
		Reports = new List<JsonReport>();
		CustomDimensions = [];

		// Defaults
		Inner = true;
		IsCustom = false;
	}

	// Returns default report type if none is specified
	public static string GetDefaultType()
	{
		return AnalyzeKeys.GridKey;
	}

	// Returns default dimension if none is specified (depends on team)
	public string GetDefaultDimension( bool isTeam1 )
	{
		return isTeam1 ? (Dimensions is { Count: > 0 } ? Dimensions[0] : KeyDimension.PlayerKey) : KeyDimension.RotationKey;
	}

	// Determines if specified report type valid for this dashboard
	public bool HasReport( string key )
	{
		return Types.Contains( key );
	}
}

//
