﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Helper class for managing data between the HeatCard and HeatView.
 */
public class HeatMap
{
	/* Constants */

	// Available map types
	public const string EfficiencyType = "efficiency";
	public const string RatingType = "rating";
	public const string CountType = "count";

	/* Properties */

	// Underlying area data
	public float[] Results { get; private set; }

	// Court side A or B?
	public RecordCourt.Side Side { get; private set; }

	// External reference
	public HeatView View { get; set; }

	/* Fields */
	private HeatCalculator calculator;

	// Underlying data
	private DataStats dataStats;

	// External ref
	public HeatCard Card { get; set; }

	/* Methods */

	// Post construction initialization
	public void Init( JsonHeat json )
	{
		calculator = new HeatCalculator
		{
			IsPassing = Card.IsPassing()
		};

		calculator.Init( json );
	}

	// Dynamically updates X-Y map dimensions
	public void UpdateAreas( int x, int y )
	{
		calculator.SetAreas( x, y );
	}

	// Updates list of stats to be drawn by this map
	public void UpdateData( DataConfig config, DataStats stats )
	{
		// Check for permission access, filter dimension(s)
		dataStats = config.Filter( stats );

		bool team1 = config.IsTeam1;

		// Map for primary team or opponent?
		calculator.IsTeam1 = team1;
		View.IsTeam1 = team1;

		// Calculate and draw
		Update();
	}

	// Draws heat map with calculated data for each area
	public void Update()
	{
		Results = calculator.Calculate( dataStats );
		Side = calculator.Side;

		// Draw result for each map area
		View.DrawResults( Results, Side );
	}
}

//
