﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Used for JSON configuration of a header stack (grouped column headers) for an individual data grid report.
 */
public class JsonStack
{
	/* Properties */
	public string Header { get; set; }
	public string Align { get; set; }

	public List<string> Keys { get; set; }

	/* Methods */

	// Returns list of keys in format needed for Syncfusion grid
	public string GetKeyList()
	{
		string field = "";

		int count = Keys.Count;

		// 'Key1,Key2,...'
		for ( int i = 0; i < count; i++ )
		{
			field += Keys[i];

			if ( i < (count - 1) ) field += ",";
		}

		return field;
	}
}

//
