﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Used for JSON deserialization of the configuration for PDF settings for an individual data grid. Nested within
 * parent JsonGrid.
 */
public class JsonGridPdf
{
	/* Properties */

	// Force grid to full page width?
	public bool FullWidth { get; set; } = false;

	// Enforce tight cell padding
	public bool LessPad { get; set; } = false;

	// Should last column be highlighted?
	public bool HighlightLast { get; set; } = false;

	// Fixed width column (-1 if NA)
	public int FixedIndex { get; set; } = 0;
	public int FixedWidth { get; set; } = 140;

	// Width if full width NOT being used (0 for grid width)
	public int ColumnWidth { get; set; } = 50;
}

//
