﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Text.Json.Serialization;

namespace iStatVball3;

/*
 * Used for JSON deserialization of the configuration for an individual data grid report on an analysis dashboard.
 */
public class JsonGrid
{
	/* Properties */

	// Static (non-dimensional) row data?
	public bool Static { get; set; }

	// Special formatting
	public string Format { get; set; }

	// Sorting enabled for this grid?
	public bool Sort { get; set; }

	// Enforce minimum width of first column?
	public bool MinWidth { get; set; }

	// More/less cell padding?
	public bool MorePad { get; set; }
	public bool LessPad { get; set; }

	// Automatically repeat defined row N times
	public int Repeat { get; set; }

	// Number frozen columns
	public int Frozen { get; set; }
	public int TotalStart { get; set; }

	// Add 0-3/0-4 rating columns?
	public string Rating { get; set; }

	// PDF export config
	public JsonGridPdf PDF { get; set; }

	// Child containers
	public IList<JsonStack> Stacks { get; set; }
	public IList<JsonColumn> Columns { get; set; }
	public IList<JsonRow> Rows { get; set; }

	// Ignored
	[JsonIgnore] public bool IsStacked => Stacks is { Count: > 0 };
	[JsonIgnore] public bool IsSpecial => (Format != null);

	/* Methods */
	public JsonGrid()
	{
		// Defaults
		Sort = true;
		MinWidth = true;
		LessPad = false;

		Frozen = 1;
		TotalStart = Frozen;

		Rating = null;
	}

	// Returns column matching specified mapping key
	public JsonColumn GetColumn( string key )
	{
		return Columns.FirstOrDefault( column => column.Key == key );
	}
}

//
