﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.Utils;

namespace iStatVball3;

/*
 * A report card containing a data grid control. The grid is dynamically configured via JSON. 
 */ 
public class GridCard : ReportCard
{
	/* Properties */
	public Grid Grid { get; private set; }

	/* Methods */
	public GridCard( JsonReport json, string dimension ) : base( json, dimension )
	{}

	// Post construction initialization
	public override void Init()
	{
		base.Init();

		// Underlying component
		Grid = new Grid
		{
			// Margin set dynamically in Grid
			Padding = 0,

			LoadComplete = OnLoadComplete
		};

		// JSON setup
		Grid.Init( json.Grid );

		// Add to layout
		layout.Add( Grid, 1, 1 );
	}

	// Refreshes all data on a standard dimensional grid card
	public override async Task UpdateData( DataConfig config )
	{
		await base.UpdateData( config );

		// Accumulate and calculate all stats
		await DataDimension.ProcessDimension( config, stats );

		// Refresh
		await Grid.UpdateData( config );
	}

	/* Layout */

	// Device/orientation specific layout
	public override void UpdateLayout( LayoutType type )
	{
		base.UpdateLayout( type );
		
		// Update children
		Grid.UpdateLayout( type );
	}
}

//
