﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.Utils;

namespace iStatVball3;

/*
 * Report card for the Bar Chart report type. Contains a report header and underlying bar chart.
 */
public class BarCard : ReportCard
{
	/* Properties */

	// External access required for PDF export
	public BarView View { get; private set; }

	/* Fields */
	private BarChart chart;

	/* Methods */
	public BarCard( JsonReport json, string dimension ) : base( json, dimension )
	{}

	// Post construction initialization
	public override void Init()
	{
		// No extra header button
		Options = null;

		base.Init();

		// Underlying control
		View = new BarView
		{
			Margin = new Thickness( (Pad + 10), 10, (Pad + 15), Pad )
		};

		// Helper class
		chart = new BarChart
		{
			View = View
		};

		// Setup chart
		View.Init( json.Bar );
		chart.Init( json.Bar );

		// Add to layout
		layout.Add( View, 1, 1 );
	}

	// Refreshes all bar chart data
	public override async Task UpdateData( DataConfig config )
	{
		await base.UpdateData( config );

		// Accumulate and calculate all stats
		await DataDimension.ProcessDimension( config, stats );

		// Refresh
		chart.UpdateData( config );

		// Required to stop spinner
		OnLoadComplete();
	}

	/* Layout */

	// Redraws entire report card
	public override void UpdateLayout( LayoutType type )
	{
		base.UpdateLayout( type );
		
		Margin = DXDevice.IsMobilePortrait() ? 0 : new Thickness( (Pad - 10), 10, (Pad - 5), Pad );

		// WORKAROUND: MAUI issues
		switch ( type )
		{
			case LayoutType.MobilePortrait:
			{
				View.Margin = new Thickness( Pad, 10, Pad, Pad );
				break;
			}
			case LayoutType.MobileLandscape:
			{
				double safe = DXDevice.SafeArea().Left;

				View.Margin = new Thickness( (safe + Pad), 10, (safe + Pad), Pad );
				break;
			}
		}

		// Update children
		View.UpdateLayout( type );
	}
}

//
