﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using Syncfusion.Drawing;

using Syncfusion.Maui.Charts;
using Syncfusion.Maui.Core;

using Syncfusion.Pdf;
using Syncfusion.Pdf.Graphics;

using DXLib.UI;

using SizeF = Syncfusion.Drawing.SizeF;

namespace iStatVball3;

/*
 * Exports a Momentum Chart into a PDF document including both the chart and report title.
 */
public static class PDFMomentum
{
	/* Methods */

	// Draws title and Momentum Chart to PDF page at specified location
	public static async Task<float> Draw( PdfDocument document, MomentumCard card, float y )
	{
		PdfPage page = document.Pages[ document.PageCount - 1 ];

		float localY = y;
		SizeF size = page.GetClientSize();

		// Scale chart
		float wd = (size.Width + 2);
		float ht = (float) Math.Round( wd * 0.50 );

		// Start new page if will not fit
		if ( (localY + ht) > size.Height )
		{
			page = document.Pages.Add();
			localY = 0;
		}

		// Card title
		localY = await PDFUtils.DrawText( page, card.Title, PDFUtils.BoldFont, 12, PDFUtils.GetColor( DXColors.Dark1 ), 0, localY );
		localY += PDFReport.TitleSpacing;

		// Convert chart to bitmap
		SfCartesianChart chart = card.View.Chart;
		PdfImage image = new PdfBitmap( await chart.GetStreamAsync( ImageFileFormat.Png ) );

		// Draw
		page.Graphics.DrawImage( image, new RectangleF( 0, localY, wd, ht ) );

		return (localY + ht);
	}
}

//
