﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using Newtonsoft.Json;

namespace iStatVball3;

/*
 * Encapsulates properties for configuring an export (PDF/Excel) as well as for populating the dynamic SendGrid email
 * template used to send the file.
 */
public class ExportConfig
{
	/* Properties */

	// Export of custom dashboard?
	[JsonIgnore] public bool IsCustom => Json is { IsCustom: true };

	// PDF config
	[JsonIgnore] public string Title { get; set; }
	[JsonIgnore] public string Team { get; set; }
	[JsonIgnore] public DateTimeOffset Date { get; set; }

	[JsonIgnore] public DataConfig DataConfig { get; set; }

	// Report specific data
	[JsonIgnore] public List<ReportCard> Cards { get; set; }
    [JsonIgnore] public List<Stat> Stats { get; set; }

	// Underlying JSON
	[JsonIgnore] public JsonDashboard Json { get; set; }

	// Email config
	[JsonIgnore] public bool IsLocal { get; set; }

	[JsonIgnore] public string FromAddress { get; set; }
	[JsonIgnore] public string FromName { get; set; }

	[JsonIgnore] public List<string> ToAddresses { get; set; }
	[JsonIgnore] public List<string> ToNames { get; set; }

	[JsonIgnore] public string Subject { get; set; }

	// SendGrid config
	public string Line1 { get; set; }
	public string Line2 { get; set; }
	public string Line3 { get; set; }
	public string Line4 { get; set; }
	public string Line5 { get; set; }
	public string Line6 { get; set; }
}

//
