﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Encapsulates all individual skill related statistic variables as well as calculated variables and statistics for a
 * single dimension entry (player, rotation, etc).
 */
public class MetricsSkill : DataMetrics
{
	/* Properties */
	
	/* Player */
	public string Player_Number { get; set; }
	public string Player_NamePos { get; set; }

	/* General */
	public int General_SetsPlayed => SetsPlayed;
	public int General_Rotations { get; set; }
	public int General_BHEs { get; set; }

	/* Scoring */
	public float Scoring_Points { get; set; }

	/* Serving */

	// Variables
	public int Serve_Zeros { get; set; }
	public int Serve_Aces { get; set; }
	public int Serve_Errors { get; set; }

	public int Serve_Points { get; set; }

	public int Serve_Rating0 { get; set; }
	public int Serve_Rating1 { get; set; }
	public int Serve_Rating2 { get; set; }
	public int Serve_Rating3 { get; set; }
	public int Serve_Rating4 { get; set; }

	public int Serve_Errors_Net { get; set; }			// Error types
	public int Serve_Errors_Ant { get; set; }
	public int Serve_Errors_Out { get; set; }
	public int Serve_Errors_Fault { get; set; }
	public int Serve_Errors_Other { get; set; }

	public int Serve_First_Zeroes { get; set; }
	public int Serve_First_Aces { get; set; }
	public int Serve_First_Errors { get; set; }

	// Calculated Variables
	public int Serve_Attempts { get; set; }
	public int Serve_Ratings { get; set; }

	public int Serve_First_Attempts { get; set; }

	// Statistics
	public float Serve_Efficiency { get; set; }
	public float Serve_Completion { get; set; }
	public float Serve_AcesPerSet { get; set; }
	public float Serve_Rating { get; set; }

    public float Serve_AcePercentage { get; set; }
    public float Serve_PointPercentage { get; set; }
	public float Serve_PointsPerRotation { get; set; }

	public float Serve_First_Percentage { get; set; }

	/* Setting */

	// Variables
	public int Set_Zeros { get; set; }
	public int Set_Assists { get; set; }
	public int Set_Errors { get; set; }

	public int Set_OtherAssists { get; set; }			// Non-attack assists

	public int Set_Rating0 { get; set; }
	public int Set_Rating1 { get; set; }
	public int Set_Rating2 { get; set; }
	public int Set_Rating3 { get; set; }
	public int Set_Rating4 { get; set; }

	// Calculated Variables
	public int Set_TotalAssists { get; set; }
	public int Set_Attempts { get; set; }
	public int Set_Ratings { get; set; }

	// Statistics
	public float Set_Efficiency { get; set; }
	public float Set_Completion { get; set; }
	public float Set_AssistsPerSet { get; set; }		// Total
	public float Set_Rating { get; set; }

	/* Hitting */

	// Variables
	public int Attack_Zeros { get; set; }
	public int Attack_Kills { get; set; }
	public int Attack_Errors { get; set; }

	public int Attack_OtherZeros { get; set; }			// Non-attack hitting
	public int Attack_OtherKills { get; set; }
	public int Attack_OtherErrors { get; set; }

	public int Attack_Errors_Net { get; set; }			// Error types
	public int Attack_Errors_Ant { get; set; }
	public int Attack_Errors_Out { get; set; }
	public int Attack_Errors_Four { get; set; }
	public int Attack_Errors_Block { get; set; }
	public int Attack_Errors_Fault { get; set; }
	public int Attack_Errors_Other { get; set; }

	// Calculated Variables
	public int Attack_Attempts { get; set; }
	public int Attack_OtherAttempts { get; set; }

	public int Attack_TotalZeros { get; set; }
	public int Attack_TotalKills { get; set; }
	public int Attack_TotalErrors { get; set; }

	public int Attack_TotalAttempts { get; set; }

	// Statistics
	public float Attack_Efficiency { get; set; }		// All totals
	public float Attack_Completion { get; set; }
	public float Attack_KillsPerSet { get; set; }

	public float Attack_KillPercentage { get; set; }
	public float Attack_ErrorPercentage { get; set; }

    /* Free (offense) */

    // Variables
    public int Free_Zeros { get; set; }
    public int Free_Kills { get; set; }
    public int Free_Errors { get; set; }

    // Calculated Variables
    public int Free_Attempts { get; set; }
	public int Free_TotalAttempts { get; set; }

    // Statistics
    public float Free_Efficiency { get; set; }
	public float Free_Completion { get; set; }
	public float Free_Percentage { get; set; }

    /* Serve Receive */

    // Variables 
    public int Receive_Zeros { get; set; }
    public int Receive_Errors { get; set; }
    public int Receive_TREs { get; set; }
    public int Receive_Converts { get; set; }

    public int Receive_Rating0 { get; set; }
    public int Receive_Rating1 { get; set; }
    public int Receive_Rating2 { get; set; }
    public int Receive_Rating3 { get; set; }
    public int Receive_Rating4 { get; set; }

    // Calculated Variables
    public int Receive_Attempts { get; set; }
    public int Receive_Ratings { get; set; }

    // Statistics
    public float Receive_Completion { get; set; }
    public float Receive_Rating { get; set; }
    public float Receive_Conversion { get; set; }

    /* Defense */

    // Variables
    public int Defense_Zeros { get; set; }
	public int Defense_Digs { get; set; }
	public int Defense_Errors { get; set; }
    public int Defense_Converts { get; set; }

    public int Defense_Rating0 { get; set; }
	public int Defense_Rating1 { get; set; }
	public int Defense_Rating2 { get; set; }
	public int Defense_Rating3 { get; set; }
	public int Defense_Rating4 { get; set; }

	// Calculated Variables
	public int Defense_Attempts { get; set; }
	public int Defense_Ratings { get; set; }

	// Statistics
	public float Defense_Efficiency { get; set; }
	public float Defense_Completion { get; set; }
	public float Defense_DigsPerSet { get; set; }
	public float Defense_Rating { get; set; }
    public float Defense_Conversion { get; set; }

    /* Freeball (defense) */

    // Variables 
    public int Freeball_Zeros { get; set; }
    public int Freeball_Errors { get; set; }
	public int Freeball_Converts { get; set; }

    public int Freeball_Rating0 { get; set; }
    public int Freeball_Rating1 { get; set; }
    public int Freeball_Rating2 { get; set; }
    public int Freeball_Rating3 { get; set; }
    public int Freeball_Rating4 { get; set; }

    // Calculated Variables
    public int Freeball_Attempts { get; set; }
    public int Freeball_Ratings { get; set; }

    // Statistics
    public float Freeball_Completion { get; set; }
    public float Freeball_Rating { get; set; }
	public float Freeball_Conversion { get; set; }

    /* Passing (First Ball, Putback) */

    // Variables 
    public int Pass_Zeros { get; set; }
	public int Pass_Errors { get; set; }
	public int Pass_Converts { get; set; }

	public int Pass_Rating0 { get; set; }
	public int Pass_Rating1 { get; set; }
	public int Pass_Rating2 { get; set; }
	public int Pass_Rating3 { get; set; }
	public int Pass_Rating4 { get; set; }

	// Calculated Variables
	public int Pass_Attempts { get; set; }
	public int Pass_Ratings { get; set; }

	// Statistics
	public float Pass_Completion { get; set; }
	public float Pass_Rating { get; set; }
    public float Pass_Conversion { get; set; }

    /* Pass Other (ALL Non-ServeReceive Passes) */

    // Calculated Variables
    public int PassOther_Ratings { get; set; }

    // Statistics
    public float PassOther_Rating { get; set; }

    /* Blocking */

    // Variables
    public int Block_Zeros { get; set; }
	public int Block_Blocks { get; set; }
	public int Block_Assists { get; set; }
	public int Block_Errors { get; set; }

	// Calculated Variables
	public int Block_Attempts { get; set; }
	public float Block_TotalBlocks { get; set; }

	// Statistics
	public float Block_Efficiency { get; set; }
	public float Block_Completion { get; set; }
	public float Block_BlocksPerSet { get; set; }

	/* Overpass */

	// Variables
	public int Over_Zeros { get; set; }
	public int Over_Kills { get; set; }
	public int Over_Errors { get; set; }

	// Calculated variables
	public int Over_Attempts { get; set; }

	/* Debug */
	public int Unknown_Action { get; set; }
	public int Unknown_Selector { get; set; }

	/* Methods */
	public MetricsSkill( bool total = false ) : base( total )
	{}

	// Use utility class to accumulate all variables for specified stat
	public override void Accumulate( DataConfig config, Stat stat, int playerNum = 1 )
	{
		MetricsSkillAccumulator.Accumulate( this, stat, playerNum );
	}

	// Use utility class to calculate all statistics for specified stat
	public override void Calculate()
	{
		MetricsSkillCalculator.Calculate( this );
	}
}

//
