﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * A wrapper for a list of Stat objects that carries additional fields needed during stat aggregation.
 */
public class DataStats : List<Stat>
{
	/* Properties */

	// Number of sets aggregated in list
	public int SetCount { get; private set; }

	// Total number points played for all sets in list
	public int TotalPoints { get; private set; }

	// Number of RallyFlow recorded sets in list
	public int RallyCount { get; private set; }
	public bool HasRally => (RallyCount > 0);

	// Reference to full stats list before filtering
	public DataStats RawStats { get; set; }

	/* Methods */

	// Increments number of aggregated sets by specified amount
	public void AddSets( int count )
	{
		SetCount += count;
	}

	// Increments total points played by specified amount
	public void AddPoints( int points )
	{
		TotalPoints += points;
	}

	// Increments number of RallyFlow recorded sets in scope
	public void AddRally( int count )
	{
		RallyCount += count;
	}

	// Adds specified stat list onto this one
	public void Add( DataStats stats )
	{
		AddRange( stats );

		AddSets( stats.SetCount );
		AddPoints( stats.TotalPoints );
		AddRally( stats.RallyCount );
	}
}

//
