﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Text.Json.Serialization;

namespace iStatVball3;

/*
 * Used for JSON deserialization of an individual Group (time, skills, etc) for the Analyze form configuration. 
 */
public class JsonGroup
{
	/* Properties */

	// Unique identifier
	public string Key { get; set; }

	// Display name
	public string Title { get; set; }

	// Underlying cards
	public IList<JsonCategory> Categories { get; set; }

	/* Ignored */
	[JsonIgnore] public bool IsCustom => Key == AnalyzeKeys.CustomKey;

	/* Methods */

	// Returns category list sorted alphabetically
	public List<JsonCategory> GetCategories()
	{
		return Categories.OrderBy( c => c.Title ).ToList();
	}
}

//
