﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Text.Json.Serialization;

namespace iStatVball3;

/*
 * Used for JSON deserialization of an individual Category (Hitting, Serving, etc) within a Group. 
 */
public class JsonCategory
{
	/* Properties */

	// Optionally hide for debug
	public bool Hidden { get; set; }

	// Unique identifier
	public string Key { get; set; }

	// Display name
	public string Title { get; set; }

	// View access open to all subscription levels?
	public bool Open { get; set; }

	// Applicable for anonymous opponent?
	public bool Opponent { get; set; } = true;

	// Include/exclude specific scopes
	public IList<string> Include { get; set; }
	public IList<string> Exclude { get; set; }

	// Is category report exportable (PDF)?
	public bool Export { get; set; } = false;

	// Eligible for adding to custom reports?
	public bool AllowCustom { get; set; } = true;

	// List of stats for category card
	public IList<JsonMetric> Metrics { get; set; }

	/* Ignored */

	// Data model for custom categories
	[JsonIgnore] public CustomDashboard Custom { get; set; }
}

//
