﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Encapsulates all fields necessary to create and initialize an Analyze dashboard form.
 */
public class DashboardConfig
{
	/* Properties */
	public string Scope { get; set; }
	public string ScopeName { get; set; }
	public object ScopeObject { get; set; }

	public Organization Organization { get; set; }

	public Team Team1 { get; set; }
	public Opponent Team2 { get; set; }

	public JsonDashboard Dashboard { get; set; }

	// Can user force data reload?
	public bool IsForceEligible { get; set; }

	// Sample organization scope?
	public bool IsSample => Organization.IsSample;

	/* Methods */

	// Determines if this configuration represents in-progress set/match
	public bool IsInProgress()
	{
		return Scope switch
		{
			// In-progress set
			DataConfig.SetScope => ScopeObject is Set { IsInProgress: true },
			
			// In-Progress match
			DataConfig.MatchScope => ScopeObject is Match { IsInProgress: true },
			
			// NA for other scopes
			_ => false
		};
	}
}

//
