﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control;

namespace iStatVball3;

/*
 * DataTemplate specifying layout for an individual custom report entry in a CustomList. Can be used as either the
 * normal or selected template.
 */
public class CustomListTemplate : DXGridLayout
{
	/* Constants */

	// Colors
	private static readonly Color SelectedColor = DXColors.Light4;
	private static readonly Color ActionColor = DXColors.Action;
	private static readonly Color TextColor = DXColors.Dark1;

	/* Methods */
	public CustomListTemplate( bool selected = false )
	{
		Color textColor = selected ? SelectedColor : TextColor;
		Color actionColor = selected ? SelectedColor : ActionColor;

		// Inverse colors for selection
		BackgroundColor = selected ? ActionColor : SelectedColor;

		Padding = 10;
		RowSpacing = 5;
		ColumnSpacing = 10;

		const double iconSize = 24;
		const double typeSize = 50;

		// Reorder
		DXIcon reorderIcon = new()
		{
			IsVisible = true,

			Size = iconSize,
			Color = selected ? SelectedColor : DXColors.Light1,
			Resource = "drag",

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center
		};

		// Type icon
		DXIcon typeIcn = new()
		{
			Size = typeSize,
			Color = selected ? DXColors.Light4 : DXColors.Action,
		
			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center
		};

		typeIcn.SetBinding( Image.SourceProperty, "Icon" );
		
		// Stat
		DXLabel statLbl = new()
		{
			TextColor = textColor,

			Font = DXFonts.RobotoBold,
			FontSize = 15,

			VAlign = TextAlignment.Start,
			LineBreakMode = LineBreakMode.TailTruncation,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Start
		};

		statLbl.SetBinding( Label.TextProperty, "StatLabel" );

		// Dimension
		DXLabel dimensionLbl = new()
		{
			TextColor = textColor,

			Font = DXFonts.Roboto,
			FontSize = 12,

			VAlign = TextAlignment.Start,
			LineBreakMode = LineBreakMode.TailTruncation,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Start
		};

		dimensionLbl.SetBinding( Label.TextProperty, "DimensionLabel" );

		// Show on card?
		DXIcon cardIcon = new()
		{
			Size = iconSize,
			Resource = "check_circle",

			Color = actionColor,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center
		};

		cardIcon.SetBinding( IsVisibleProperty, "IsOnCard" );

		AddStarRow( 50 );				// 0: stat
		AddStarRow( 50 );				// 1: detail

		AddFixedColumn( iconSize );     // 0: reorder
		AddFixedColumn( typeSize );		// 1: type
		AddStarColumn();				// 2; stat,dimension
		AddFixedColumn( iconSize );     // 3: card

		// Add components
		Add( reorderIcon, 0, 0, 1, 2 );
		Add( typeIcn, 1, 0, 1, 2 );
		Add( statLbl, 2, 0 );
		Add( dimensionLbl, 2, 1 );
		Add( cardIcon, 3, 0, 1, 2 );
	}
}

//
