﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control.Button;

namespace iStatVball3;

/*
 * Data template defining layout for the swipe to delete view in the custom report list.
 */
public class CustomListDelete : DXGridLayout
{
	/* Events */
	public Action Deleted { get; set; }

	/* Methods */
	public CustomListDelete()
	{
		// Layout
		BackgroundColor = DXColors.Negative;

		Padding = 0;
		RowSpacing = 0;
		ColumnSpacing = 0;

		Horizontal = LayoutOptions.Fill;
		Vertical = LayoutOptions.Fill;

		// Trash icon
		DXIconButton deleteIcon = new()
		{
			Resource = "delete",
			IconColor = DXColors.Light4,

			Margin = new Thickness( 2, 2, 0, 0 ),
			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center,

			HasShadow = false,
			IsSticky = false,

			ButtonTapped = OnItemDeleted
		};

		deleteIcon.SetSize( 36, false );
		
		Add( deleteIcon, 0, 0 );
	}

	/* Event Callbacks */

	// User tapped trash icon in delete view, notify listener
	private void OnItemDeleted()
	{
		Deleted?.Invoke();
	}
}

//
