﻿using Syncfusion.EJ2.Base;
using Syncfusion.EJ2.Linq;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using WebApplication1.Models;

namespace WebApplication1.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult About()
        {
            ViewBag.Message = "Your application description page.";

            return View();
        }

        public ActionResult Contact()
        {
            ViewBag.Message = "Your contact page.";

            return View();
        }

        public ActionResult UrlDatasource(DataManagerRequest dm)
        {
            IEnumerable DataSource = GetSampleData();
            DataOperations operation = new DataOperations();
            List<string> str = new List<string>();
            if (dm.Search != null && dm.Search.Count > 0)
            {
                DataSource = operation.PerformSearching(DataSource, dm.Search);  //Search
            }
            if (dm.Sorted != null && dm.Sorted.Count > 0) //Sorting
            {
                DataSource = operation.PerformSorting(DataSource, dm.Sorted);
            }
            if (dm.Where != null && dm.Where.Count > 0) //Filtering
            {
                DataSource = operation.PerformFiltering(DataSource, dm.Where, dm.Where[0].Operator);
            }
            int count = DataSource.ToList<ItemModel>().Count();
            if (dm.Skip != 0)
            {
                DataSource = operation.PerformSkip(DataSource, dm.Skip);         //Paging
            }
            if (dm.Take != 0)
            {
                DataSource = operation.PerformTake(DataSource, dm.Take);
            }
            return dm.RequiresCounts ? Json(new { result = DataSource, count = count }) : Json(DataSource);
        }

        private IEnumerable<ItemModel> GetSampleData()
        {
            return new List<ItemModel>
            {
                new ItemModel { Id = 1, Name = "Item 1", Description = "Description for Item 1" },
                new ItemModel { Id = 2, Name = "Item 2", Description = "Description for Item 2" },
                new ItemModel { Id = 3, Name = "Item 3", Description = "Description for Item 3" },
                new ItemModel { Id = 4, Name = "Item 4", Description = "Description for Item 4" },
                new ItemModel { Id = 5, Name = "Item 5", Description = "Description for Item 5" },
                new ItemModel { Id = 6, Name = "Item 6", Description = "Description for Item 6" },
                new ItemModel { Id = 7, Name = "Item 7", Description = "Description for Item 7" },
                new ItemModel { Id = 8, Name = "Item 8", Description = "Description for Item 8" },
                new ItemModel { Id = 9, Name = "Item 9", Description = "Description for Item 9" },
                new ItemModel { Id = 10, Name = "Item 10", Description = "Description for Item 10" },
                new ItemModel { Id = 11, Name = "Item 11", Description = "Description for Item 11" },
                new ItemModel { Id = 12, Name = "Item 12", Description = "Description for Item 12" },
                new ItemModel { Id = 13, Name = "Item 13", Description = "Description for Item 13" },
                new ItemModel { Id = 14, Name = "Item 14", Description = "Description for Item 14" },
                new ItemModel { Id = 15, Name = "Item 15", Description = "Description for Item 15" }
            };
        }
    }
}