﻿using Microsoft.AspNetCore.Http.Features;
using Microsoft.AspNetCore.Mvc;
using System.Net.Http.Headers;

namespace BlazorApp1
{
    [Route("api/[controller]")]
    public class SampleDataController : Controller
    {
       
        private readonly IWebHostEnvironment hostingEnv;

        public SampleDataController(IWebHostEnvironment env)
        {
            this.hostingEnv = env;
        }

        
        [HttpPost("[action]")]
        [Route("api/Home/SaveRte")]
        public void SaveRte(IList<IFormFile> UploadFiles)
        {
            try
            {
                foreach (var file in UploadFiles)
                {
                    if (UploadFiles != null)
                    {
                        string targetPath;
                        var form = Request.Form["Subfolder"];
                        if(form == "True")
                        {
                            targetPath = hostingEnv.ContentRootPath + "\\wwwroot\\Images\\SubImages";
                        }
                        else
                        {
                            targetPath = hostingEnv.ContentRootPath + "\\wwwroot\\Images";
                        }
                            
                        string filename = ContentDispositionHeaderValue.Parse(file.ContentDisposition).FileName.Trim('"');

                        // Create a new directory, if it does not exists
                        if (!Directory.Exists(targetPath))
                        {
                            Directory.CreateDirectory(targetPath);
                        }

                        // Name which is used to save the image
                        filename = targetPath + $@"\{filename}";

                        if (!System.IO.File.Exists(filename))
                        {
                            // Upload a image, if the same file name does not exist in the directory
                            using (FileStream fs = System.IO.File.Create(filename))
                            {
                                file.CopyTo(fs);
                                fs.Flush();
                            }
                            Response.StatusCode = 200;
                        }
                        else
                        {
                            Response.StatusCode = 204;
                        }
                    }
                }
            }
            catch (Exception e)
            {
                Response.Clear();
                Response.ContentType = "application/json; charset=utf-8";
                Response.HttpContext.Features.Get<IHttpResponseFeature>().ReasonPhrase = e.Message;
            }
        }


       
    }
}
