﻿
using System;


namespace SfDataGridStackedHeader
{
    public class StreamingDataHeader
    {
        public enum Aggregates { Count = 1, Max = 2, Min = 3, Average = 4, Sum = 5, VAP = 6 }

        public string Header { get; set; }
        public int? NavigationID { get; set; }
        public bool? IsNumber { get; set; }
        public bool? IsImage { get; set; }
        public bool? IsColor { get; set; }
        public bool? IsHidden { get; set; }
        public bool? IsPopis { get; set; }
        public string Aggregate { get; set; }
        public string Levels { get; set; }
        public string Format { get; set; }
        public int? FieldID { get; set; }
        public int? FieldType { get; set; }
        public string VAPheader { get; set; }
        public string ColumnType { get; set; }
        public string Tag1 { get; set; }
        public string Tag2 { get; set; }
        public int? ColorForIndex { get; set; }
        public string HasNavDeciderColumnName { get; set; }
        public string HasNavDeciderConverter { get; set; }

        public static StreamingDataHeader LoadWL3(string settings)
        {
            var data = new StreamingDataHeader();
            var items = settings.Split('|');
            for (int i = 0; i < items.Length; i++)
            {
                var index = i;
                var item = items[i];
                if (items[i].Contains("#"))
                {
                    index = int.Parse(items[i].Split('#')[0]);
                    item = items[i].Split('#')[1];
                }

                switch (index)
                {
                    case 0: data.Header = item; break;
                    case 1: data.NavigationID = int.Parse(item); break;
                    case 2: data.IsNumber = item == "1" ? true : false; break;
                    case 3: data.IsHidden = item == "1" ? true : false; break;
                    case 4: data.IsPopis = item == "1" ? true : false; break;
                    case 5: data.Aggregate = ((Aggregates)int.Parse(item)).ToString(); break;
                    case 6: data.Levels = item; break;
                    case 7: data.Format = item; break;
                    case 8: data.FieldID = int.Parse(item); break;
                    case 9: data.FieldType = int.Parse(item); break;
                    case 10: data.VAPheader = item; break;
                    case 11: data.ColumnType = item; break;
                    case 12: data.IsImage = item == "1" ? true : false; break;
                    case 13: data.Tag1 = item; break;
                    case 14: data.Tag2 = item; break;
                    case 15: data.IsColor = item == "1" ? true : false; break;
                    case 16: data.ColorForIndex = int.Parse(item); break;
                    case 17: data.HasNavDeciderColumnName = item; break;
                    case 18: data.HasNavDeciderConverter = item; break;
                    default: break;
                }
            }
            return data;
        }

        public static StreamingDataHeader[] ExtractFromColumns(string[] columns)
        {
            if (columns == null) return [];
            var data = new StreamingDataHeader[columns.Length];
            for (int i = 0; i < columns.Length; i++)
            {
                try { data[i] = LoadWL3(columns[i].Contains("°") ? columns[i].Split('°')[1] : columns[i]); }
                catch { data[i] = new StreamingDataHeader { Header = columns[i] }; }
            }
            return data;
        }
    }
}
