﻿using Javax.Xml.Transform;
using Syncfusion.Maui.Data;
using Syncfusion.Maui.DataGrid;

namespace SfDataGridStackedHeader
{
    public partial class MainPage : ContentPage
    {
        int count = 0;

        public MainPage()
        {
            InitializeComponent();

            var columns = "PSL\tporast\tužívanie\tvýmera\tPlocha1_1301#°0#skutočná#|5#5|6#predpis PSL(LHE 1101,1102,1301)^prečistková plocha|7#N2|11#System.Decimal\tPlocha_1301#°0#násobná#|5#5|6#predpis PSL(LHE 1101,1102,1301)^prečistková plocha|7#N2|11#System.Decimal\tPlocha1_1101#°0#skutočná#|5#5|6#predpis PSL(LHE 1101,1102,1301)^prebierková plocha|7#N2|11#System.Decimal\tPlocha_1101#°0#násobná#|5#5|6#predpis PSL(LHE 1101,1102,1301)^prebierková plocha|7#N2|11#System.Decimal\tObjem1101#°0#m3#|5#5|6#predpis PSL(LHE 1101,1102,1301)^objem|7#N0|11#System.Decimal\tPlochaUpravena1_1301#°0#skutočná#|5#5|6#upravený predpis PSL(LHE 1101,1102,1301)^prečistková plocha|7#N2|11#System.Decimal\tPlochaUpravena_1301#°0#násobná#|5#5|6#upravený predpis PSL(LHE 1101,1102,1301)^prečistková plocha|7#N2|11#System.Decimal\tPlochaUpravena1_1101#°0#skutočná#|5#5|6#upravený predpis PSL(LHE 1101,1102,1301)^prebierková plocha|7#N2|11#System.Decimal\tPlochaUpravena_1101#°0#násobná#|5#5|6#upravený predpis PSL(LHE 1101,1102,1301)^prebierková plocha|7#N2|11#System.Decimal\tObjemUpraveny1101#°0#m3#|5#5|6#upravený predpis PSL(LHE 1101,1102,1301)^objem|7#N0|11#System.Decimal\tPlocha601_602#°0#prerezávky~ + čistky#|5#5|6#vykonaná výchova (LHE 404,405,406,601,602)|7#N2|11#System.Decimal\tPlocha404#°0#prebierková~ plocha#|5#5|6#vykonaná výchova (LHE 404,405,406,601,602)|7#N2|11#System.Decimal\tMnozstvo404#°0#m3#|5#5|6#vykonaná výchova (LHE 404,405,406,601,602)^objem|7#N0|11#System.Decimal\tZostPlochaPrecist#°0#prečistková~ plocha#|5#5|6#zostávajúce úlohy voči (upr.) predpisu|7#N2|11#System.Decimal\tZostPlochaPrebier#°0#prebierková~ plocha#|5#5|6#zostávajúce úlohy voči (upr.) predpisu|7#N2|11#System.Decimal\tZostObjem#°0#m3#|5#5|6#zostávajúce úlohy voči (upr.) predpisu^objem|7#N0|11#System.Decimal\tJeUpravaPlocha1_1101?\tJeUpravaPlocha1101?\tJeUpravaPlocha1_1301?\tJeUpravaPlocha1301?\tJeUpravaObjem?".Split('\t');
            var header = StreamingDataHeader.ExtractFromColumns(columns) ?? [];

            if (header.Count(x => x.Levels != null) > 0)
            {
                var maxLevel = header.Where(x => x.Levels != null).Max(x => x.Levels.Split('^').Length);
                DG_Data.StackedHeaderRows.Clear();
                for (int i = 0; i < maxLevel; i++)
                {
                    DG_Data.StackedHeaderRows.Add(new DataGridStackedHeaderRow());
                    var lastLevelAdded = "";
                    for (int j = 0; j < header.Length; j++)
                    {
                        if (header[j].Levels == null || header[j].Levels.Split('^').Length <= i)
                            continue;
                        var level = header[j].Levels.Split('^')[i].Replace("~", Environment.NewLine);
                        if (lastLevelAdded == level) DG_Data.StackedHeaderRows[i].Columns.Last().ColumnMappingNames += $",Values[{j}].Value";
                        else
                        {
                            lastLevelAdded = level;
                            DG_Data.StackedHeaderRows[i].Columns.Add(new DataGridStackedColumn { ColumnMappingNames = $"Values[{j}].Value", MappingName = $"Values[{j}].Value", Text = level });
                        }
                    }
                }
            }

            for (int i = 0; i < header.Length; i++)
            {
                if (header[i].IsHidden ?? false) continue;

                var col = (DataGridColumn?)null;
                if (header[i].IsNumber ?? false)
                {
                    if (header[i].Format == null)
                    {
                        if (header[i].ColumnType != "System.Decimal")
                            header[i].Format = "D";
                        else
                            header[i].Format = "N2";
                    }
                    col = new DataGridNumericColumn
                    {
                        CellTextAlignment = TextAlignment.End,
                        Format = header[i].Format,
                    };
                }
                else if (header[i].ColumnType?.Contains("System.DateTime") ?? false) col = new DataGridDateColumn { CellTextAlignment = TextAlignment.End, DisplayBinding = new Binding($"Values[{i}].Value") };
                else if (header[i].ColumnType?.Contains("System.Boolean") ?? false) col = new DataGridCheckBoxColumn();
                else col = new DataGridTextColumn { Visible = !(header[i].IsPopis ?? false), CellTextAlignment = TextAlignment.Start };

                col.MappingName = $"Values[{i}].Value";
                col.HeaderText = header[i].IsPopis ?? false ? "" : header[i].Header.Replace("~", Environment.NewLine).Replace("ToolTip?", "");
                col.AllowSorting = true;
                col.MinimumWidth = 30;
                col.HeaderTextAlignment = TextAlignment.Center;
                col.AllowEditing = false;
                col.CellPadding = new Thickness(5, 3, 5, 0);
                col.HeaderPadding = new Thickness(0, 0, 0, 0);

                if (header[i].IsPopis ?? false)
                    col.CellTextAlignment = TextAlignment.Start;

                DG_Data.Columns.Add(col);

            }

            var data = new List<DataRow>();
            for (int r = 0; r < 100; r++)
            {
                var row = new DataRow();
                for (int c = 0; c < header.Length; c++)
                {
                    var val = new DataValue();
                    if (header[c].ColumnType?.Contains("System.Int32") ?? false) val.Value = r * 10 + c;
                    else if (header[c].ColumnType?.Contains("System.Decimal") ?? false) val.Value = Math.Round((decimal)(r * 10.1234 + c), 2);
                    else if (header[c].ColumnType?.Contains("System.DateTime") ?? false) val.Value = DateTime.Now.AddDays(r);
                    else if (header[c].ColumnType?.Contains("System.Boolean") ?? false) val.Value = (r % 2 == 0);
                    else if (header[c].ColumnType?.Contains("System.String") ?? false)
                    {
                        if (header[c].Header.Contains("porast")) val.Value = $"Porast {r % 10}";
                        else if (header[c].Header.Contains("užívanie"))
                        {
                            var uzivanie = new string[] { "LP", "LD", "PH", "OH", "NP" };
                            val.Value = uzivanie[r % 5];
                        }
                        else val.Value = $"Riadok {r}, stĺpec {c}";
                    }
                    else val.Value = $"Riadok {r}, stĺpec {c}";
                    row.Values.Add(val);
                }
                data.Add(row);
            }

            DG_Data.ItemsSource = data;
        }
    }
}
