﻿using System.Collections.ObjectModel;
using System.Diagnostics;

namespace SimpleSamplePicker
{
    public partial class MainPage : ContentPage
    {

        public MainPage()
        {
            InitializeComponent();
        }

        private void datePicker_SelectionChanged(object sender, Syncfusion.Maui.Picker.DatePickerSelectionChangedEventArgs e)
        {
            Debug.WriteLine($"Old selected date: {e.OldValue} ------ New selected date: {e.NewValue}");
            DisplayAlert($"Date Selected", $"Old selected date: {e.OldValue} \nNew selected date: {e.NewValue}", "OK");
        }

        private void Button_Clicked(object sender, EventArgs e)
        {
            this.datePicker.IsOpen = true;
            //this.datePicker.SelectedDate = null;
        }

        private void timePicker_SelectionChanged(object sender, Syncfusion.Maui.Picker.TimePickerSelectionChangedEventArgs e)
        {
            Debug.WriteLine($"Old selected time: {e.OldValue} ------ New selected time: {e.NewValue}");
            DisplayAlert($"Time Selected", $"Old selected time: {e.OldValue} \nNew selected time: {e.NewValue}", "OK");
        }

        private void Button_Clicked_1(object sender, EventArgs e)
        {
            this.timePicker.IsOpen = true;
        }

        private void picker_SelectionChanged(object sender, Syncfusion.Maui.Picker.PickerSelectionChangedEventArgs e)
        {
            Debug.WriteLine($"Old selected index: {e.OldValue} ------ New selected index: {e.NewValue} at column index: {e.ColumnIndex}");
            DisplayAlert($"Picker Selected", $"Old selected index: {e.OldValue} New selected index: {e.NewValue}\nColumn index: {e.ColumnIndex}", "OK");
        }

        private void dateTimePicker_SelectionChanged(object sender, Syncfusion.Maui.Picker.DateTimePickerSelectionChangedEventArgs e)
        {
            Debug.WriteLine($"Old selected date time: {e.OldValue} ------ New selected date time: {e.NewValue}");
            DisplayAlert($"Date Time Selected", $"Old selected date time: {e.OldValue} \nNew selected date time: {e.NewValue}", "OK");
        }

        private void Button_Clicked_2(object sender, EventArgs e)
        {
            this.dateTimePicker.IsOpen = true;
        }

        private void Button_Clicked_3(object sender, EventArgs e)
        {
            this.picker.IsOpen = true;
        }

        private void MinimumDatePicker_DateSelected(object sender, DateChangedEventArgs e)
        {
            this.datePicker.MinimumDate = MinimumDatePicker.Date;
        }

        private void MaximumDatePicker_DateSelected(object sender, DateChangedEventArgs e)
        {
            this.datePicker.MaximumDate = MaximumDatePicker.Date;
        }

        private void MaximumTimePicker_TimeSelected(object sender, TimeChangedEventArgs e)
        {
            this.timePicker.MaximumTime = MaximumTimePicker.Time;
        }

        private void MinimumTimePicker_TimeSelected(object sender, TimeChangedEventArgs e)
        {
            this.timePicker.MinimumTime = MinimumTimePicker.Time;
        }

        int clicked = 0;
        private void Button_Clicked_4(object sender, EventArgs e)
        {
            this.dateTimePicker.SelectedDate = null;
        }

        private void Button_Clicked_5(object sender, EventArgs e)
        {
            this.datePicker.SelectedDate = null;
        }

        private void Button_Clicked_6(object sender, EventArgs e)
        {
            this.timePicker.SelectedTime = null;
        }

        private void Button_Clicked_7(object sender, EventArgs e)
        {
            this.picker.Columns[0].SelectedIndex = -1;
        }

        int count = 0;
        private void Button_Clicked_8(object sender, EventArgs e)
        {
            count++;
            if (count % 2 == 1)
            {
                this.picker.FooterView.Height = 0;
            }
            else
            {
                this.picker.FooterView.Height = 40;
            }
        }

        int count2 = 0;
        private void Button_Clicked_9(object sender, EventArgs e)
        {
            count2++;
            if (count2 % 2 == 1)
            {
                this.datePicker.FooterView.Height = 0;
            }
            else
            {
                this.datePicker.FooterView.Height = 40;
            }
        }

        int count3 = 0;
        private void Button_Clicked_10(object sender, EventArgs e)
        {
            count3++;
            if (count3 % 2 == 1)
            {
                this.timePicker.FooterView.Height = 0;
            }
            else
            {
                this.timePicker.FooterView.Height = 40;
            }
        }

        int count4 = 0;
        private void Button_Clicked_11(object sender, EventArgs e)
        {
            count4++;
            if (count4 % 2 == 1)
            {
                this.dateTimePicker.FooterView.Height = 0;
            }
            else
            {
                this.dateTimePicker.FooterView.Height = 40;
            }
        }

        private void Switch_Toggled(object sender, ToggledEventArgs e)
        {
            if (this.picker == null)
                return;

            if (!e.Value)
            {
                this.picker.FooterView.ShowOkButton = e.Value;
            }
            else
            {
                this.picker.FooterView.ShowOkButton = e.Value;
            }
        }

        private void Switch_Toggled_1(object sender, ToggledEventArgs e)
        {
            if (this.datePicker == null)
                return;

            if (!e.Value)
            {
                this.datePicker.FooterView.ShowOkButton = e.Value;
            }
            else
            {
                this.datePicker.FooterView.ShowOkButton= e.Value;
            }
        }

        private void Switch_Toggled_2(object sender, ToggledEventArgs e)
        {
            if (this.timePicker == null)
                return;

            if (!e.Value)
            {
                this.timePicker.FooterView.ShowOkButton = e.Value;
            }
            else
            {
                this.timePicker.FooterView.ShowOkButton = e.Value;
            }
        }

        private void Switch_Toggled_3(object sender, ToggledEventArgs e)
        {
            if (this.dateTimePicker == null)
                return;

            if (!e.Value)
            {
                this.dateTimePicker.FooterView.ShowOkButton = e.Value;
            }
            else
            {
                this.dateTimePicker.FooterView.ShowOkButton = e.Value;
            }
        }
    }
}
