﻿using Syncfusion.UI.Xaml.Charts;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Globalization;
using System.Linq;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Sample_WPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window, INotifyPropertyChanged
    {
        private double rangeStart = 0;
        private double rangeEnd = 0;

        public MainWindow()
        {
            InitializeComponent();
        }

        public double RangeStart
        {
            get { return rangeStart; }
            set
            {
                if (rangeStart != value)
                {
                    rangeStart = value;
                    RangeStartTextBox.Text = RangeStart.ToString();
                    OnPropertyChanged();
                }
            }
        }

        public double RangeEnd
        {
            get { return rangeEnd; } // Fixed end value for the range
            set
            {
                if (rangeEnd != value)
                {
                    rangeEnd = value;
                    RangeEndTextBox.Text = RangeEnd.ToString();
                    OnPropertyChanged();
                }
            }
        }

        public double? SaMax
        {
            get { return secondaryAxis.Maximum; }
            set
            {
                if (secondaryAxis.Maximum != value)
                {
                    secondaryAxis.Maximum = value;
                    SaMaxTextBox.Text = SaMax.ToString();
                    OnPropertyChanged();
                }
            }

        }

        public double? SaMin
        {
            get { return secondaryAxis.Minimum; }
            set
            {
                if (secondaryAxis.Minimum != value)
                {
                    secondaryAxis.Minimum = value;
                    SaMinTextBox.Text = SaMin.ToString();
                    OnPropertyChanged();
                }
            }
        }


        private void chart_ZoomChanged(object sender, ZoomChangedEventArgs e)
        {
            if (e.NewRange != null && e.CurrentFactor != 1)
            {
                var range = (DoubleRange)(e.NewRange);
                var x1 = range.Start;
                RangeStart = x1;
                var x2 = range.End;
                RangeEnd = x2;
                var y1 = 0; // (double)secondaryAxis.VisibleRange.Start;
                var y2 = 100.0; // (double)secondaryAxis.VisibleRange.End;

                var collection = (chart.Series[0] as CandleSeries).GetDataPoints(x1, x2, y1, y2);

                UpdateAxisRange(collection);
            }
        }

        private void chart_SelectionZoomingEnd(object sender, SelectionZoomingEndEventArgs e)
        {
            var collection = (chart.Series[0] as CandleSeries).GetDataPoints(e.ZoomRect);
            UpdateAxisRange(collection);
        }

        private void UpdateAxisRange(List<object> collection)
        {
            List<Model> data = new List<Model>();
                foreach (var datapoint in collection)
                {
                    data.Add(datapoint as Model);
                }

            SaMax = data.Max(a => a.High);
            SaMin = data.Min(a => a.Low);
        }




        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged([CallerMemberName] string name = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(name));
        }

    }
}
