﻿using Syncfusion.UI.Xaml.Charts;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Media;
using System.Windows.Threading;

namespace Sample_WPF
{
    public class DataGenerator
    {
        private Random random;
        public ObservableCollection<Model> Data { get; set; }

        public DataGenerator()
        {
            random = new Random();
            Data = new ObservableCollection<Model>();

            Data.Add(new Model(1, 80, 60, 55, 70));
            Data.Add(new Model(2, 90, 75, 85, 78));
            Data.Add(new Model(3, 75, 65, 68,72 ));
            Data.Add(new Model(4, 68, 62, 64, 66 ));
            Data.Add(new Model(5, 50, 40, 48, 44 ));
            Data.Add(new Model(6, 54, 48, 50,52 ));
            Data.Add(new Model(7, 55, 45, 52, 42 ));
            Data.Add(new Model(8, 35, 15, 25, 30 ));
            Data.Add(new Model(9, 30, 10, 18, 14 ));
            Data.Add(new Model(10, 28, 14, 18, 24));
            Data.Add(new Model(11, 25, 15, 17, 22));
            Data.Add(new Model(12, 20, 8, 12, 18));

        }
    }

    public class RangeObservableCollection<T> : ObservableCollection<T>
    {
        private bool _suppressNotification = false;

        protected override void OnCollectionChanged(NotifyCollectionChangedEventArgs e)
        {
            if (!_suppressNotification)
                base.OnCollectionChanged(e);
        }

        public void AddRange(ObservableCollection<T> list, int startingIndex, int endingIndex)
        {
            if (list == null)
                throw new ArgumentNullException("list");

            _suppressNotification = true;

            //foreach (T item in list)
            //{
            //    Add(item);
            //}
            for (int i = startingIndex; i < endingIndex; i++)
            {
                Add(list[i]);
            }
            _suppressNotification = false;
            OnCollectionChanged(new NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction.Reset));
        }
    }

    public class Model
    {
        public Model(double xValue, double value, double value1, double value2 , double value3)
        {
            XValue = xValue;
            High = value;
            Low = value1;
            Open = value2;
            Close = value3;
        }
        
        public double XValue { get; set; }

        public double High { get; set; }

        public double Low { get; set; }

        public double Open { get; set; }

        public double Close { get; set; }

    }
}
