﻿using Syncfusion.DocIO.DLS;
using Syncfusion.DocIO;
using System;
using System.IO;

namespace AppendHtml_Test
{
    internal class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Press a key to begin");
            Console.ReadKey();

            //Open an existing Word document.
            using (WordDocument document = new WordDocument())
            {
                string strQuestion2Html = File.ReadAllText(@"Input2.html");
                IWSection section = document.AddSection();

                var section1IntroductionParagraph = section.AddParagraph();
                section1IntroductionParagraph.AppendHTML("<b>Section 1</b>");

                var section1Question1Paragraph = section.AddParagraph();
                section1Question1Paragraph.AppendText("Question 1");
                section1Question1Paragraph.ListFormat.ApplyDefNumberedStyle();


                var section1Question2Paragraph = section.AddParagraph();
                section1Question2Paragraph.AppendHTML(strQuestion2Html);
                section1Question2Paragraph.ListFormat.ApplyDefNumberedStyle();
                section1Question2Paragraph.ParagraphFormat.SpaceAfterAuto = false;

                WParagraph nextPara = section1Question2Paragraph.NextSibling as WParagraph;
                while (nextPara != null)
                {
                    nextPara.ParagraphFormat.LeftIndent = 100;
                    nextPara.ParagraphFormat.SpaceBeforeAuto = false;
                    nextPara = nextPara.NextSibling as WParagraph;
                }




                var section2IntroductionParagraph = section.AddParagraph();
                section2IntroductionParagraph.AppendHTML("<br /><b>Section 2</b>");

                var section2Question1Paragraph = section.AddParagraph();
                section2Question1Paragraph.AppendText("Question 1");
                section2Question1Paragraph.ListFormat.ApplyDefNumberedStyle();
                section2Question1Paragraph.ListFormat.RestartNumbering = true;

                var section2Question2Paragraph = section.AddParagraph();
                section2Question2Paragraph.AppendText("Question 2");
                section2Question2Paragraph.ListFormat.ApplyDefNumberedStyle();

                //Save the Word document
                using (var outputFilestream = new FileStream(@"../../output.docx", FileMode.Create))
                {
                    document.Save(outputFilestream, FormatType.Docx);
                }
            }
        }
    }
}
