﻿using Syncfusion.Windows.Shared;
using Syncfusion.Windows.Tools.Controls;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Xml;

namespace DockTest;

/// <summary>
/// Interaction logic for MainWindow.xaml
/// </summary>
public partial class MainWindow : Window
{
    public MainWindow()
    {
        InitializeComponent();
        (dockingManager.DocContainer as DocumentContainer).Loaded += MainWindow_Loaded;
    }

    private void MainWindow_Loaded(object sender, RoutedEventArgs e)
    {
        this.dockingManager.CreateHorizontalTabGroup(CheckDockControl);
        Customize();
    }

    void Customize()
    {
        var tabGroups = VisualUtils.EnumChildrenOfType(dockingManager, typeof(DocumentTabControl))
        .OfType<DocumentTabControl>().ToList();

        DocumentTabControl targetTabGroup = null;
        foreach (var tabGroup in tabGroups)
        {
            var tabItem = RetrieveTabItem(tabGroup, CheckDockControl);
            if (tabItem != null)
            {
                targetTabGroup = tabGroup;
                break;
            }
        }

        if (targetTabGroup == null)
            return;

        var batchTabExist = RetrieveTabItem(targetTabGroup, BatchStepLogDockControl);
        var securityTabExist = RetrieveTabItem(targetTabGroup, SecurityLogDockControl);

        if (batchTabExist == null && securityTabExist == null)
        {
            dockingManager.AddElementToTabGroup(targetTabGroup, BatchStepLogDockControl);
            dockingManager.AddElementToTabGroup(targetTabGroup, SecurityLogDockControl);

        }
          
    }
    private static TabItemExt RetrieveTabItem(DocumentTabControl tabControl, FrameworkElement element)
    {
        TabItemExt itemExt = null;
        foreach (TabItemExt item in tabControl.Items)
        {
            if ((item.Content as ContentPresenter).Content == element)
            {
                itemExt = item;
                break;
            }
        }

        return itemExt;
    }
}