using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Syncfusion.EJ2.Base;
using Syncfusion.EJ2.GridExport;
using System.Collections;
using System.ComponentModel.DataAnnotations;
using WebApplication1.Models;
using Syncfusion.EJ2.Grids;
using Syncfusion.Pdf.Graphics;
using System.IO;
using Syncfusion.Pdf;
using Syncfusion.Pdf.Grid;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc.RazorPages;
using Syncfusion.Drawing;
using System.Reflection.Metadata;
using System.Xml.Linq;

namespace WebApplication1.Controllers
{
    public class HomeController : Controller
    {
        private readonly ILogger<HomeController> _logger;

        public HomeController(ILogger<HomeController> logger)
        {
            _logger = logger;
        }



        public static List<Orders> order = new List<Orders>();
        public IActionResult Index()
        {
            ViewBag.DataSource = Movements.getAllRecords().ToList();
            return View();
        }

        public IActionResult UrlDatasource([FromBody] DataManagerRequest dm)
        {
            var DataSource = Movements.getAllRecords().AsQueryable();
            QueryableOperation operation = new QueryableOperation();
            if (dm.Search != null && dm.Search.Count > 0)
            {
                DataSource = operation.PerformSearching(DataSource, dm.Search);  //Search
            }
            if (dm.Sorted != null && dm.Sorted.Count > 0) //Sorting
            {
                DataSource = operation.PerformSorting(DataSource, dm.Sorted);
            }
            try
            {
                if (dm.Where != null && dm.Where.Count > 0) //Filtering
                {
                    DataSource = operation.PerformFiltering(DataSource, dm.Where, dm.Where[0].Operator);
                }
            }
            catch (Exception)
            {
                //todo why throwing argument exception??
            }
            int count = DataSource.Cast<Orders>().Count();
            if (dm.Skip != 0)
            {
                DataSource = operation.PerformSkip(DataSource, dm.Skip);   //Paging
            }
            if (dm.Take != 0)
            {
                DataSource = operation.PerformTake(DataSource, dm.Take);
            }
            return dm.RequiresCounts ? Json(new { result = DataSource, count = count }) : Json(DataSource);
        }

        [HttpPost]
        public async Task<IActionResult> ExcelExport([FromForm] string gridModel, string filterData)
        {
            GridExcelExport excelExporter = new GridExcelExport();
            Grid gridProperties = ConvertGridObject(gridModel);
            var data = Movements.getAllRecords().ToList();
            return excelExporter.ExcelExport<Movements>(gridProperties, data);
        }

        private Grid ConvertGridObject(string gridProperty)
        {
            Grid GridModel = (Grid)Newtonsoft.Json.JsonConvert.DeserializeObject(gridProperty, typeof(Grid));
            GridColumnModel cols = (GridColumnModel)Newtonsoft.Json.JsonConvert.DeserializeObject(gridProperty, typeof(GridColumnModel));
            GridModel.Columns = cols.columns;
            return GridModel;
        }

        public class GridColumnModel
        {
            public List<GridColumn> columns { get; set; }
        }

        public class CRUDModel
        {
            public List<Orders> Added { get; set; }
            public List<Orders> Changed { get; set; }
            public List<Orders> Deleted { get; set; }
            public Orders Value { get; set; }
            public int key { get; set; }
            public string action { get; set; }
        }

        public class Orders
        {
            public Orders() { }

            public Orders(long orderId, string customerId, int employeeId, double freight, DateTime orderDate, string shipCity, string shipCountry, bool checkedField,
                          string productName, int quantity, double unitPrice, double totalPrice, string status, string paymentMethod, string deliveryTime,
                          DateTime shipDate, string shipAddress, string shipPostalCode, string shipRegion, string customerName, string customerPhone,
                          string customerEmail, string customerCompany, string employeeName, string employeePosition, string department, string warehouse,
                          string productCategory, string productSupplier, string productSku, string productBarCode, string promoCode, double discount,
                          string shippingMethod, bool isGift, string giftMessage, DateTime estimatedDeliveryDate, string taxType, double taxAmount,
                          string invoiceNumber, DateTime invoiceDate, string currency, string customerLoyaltyLevel, double rewardPointsUsed,
                          bool isSubscription, int subscriptionDuration, string subscriptionStatus, string subscriptionType, string referralSource,
                          string orderNotes, string packagingType, bool requiresAssembly, string returnPolicy, string supplierContact, string orderChannel,
                          string deliveryInstructions, bool expeditedShipping, bool backOrder, string fulfillmentCenter, bool isWholesale)
            {
                OrderID = orderId;
                CustomerID = customerId;
                EmployeeID = employeeId;
                Freight = freight;
                OrderDate = orderDate;
                ShipCity = shipCity;
                ShipCountry = shipCountry;
                Checked = checkedField;

                ProductName = productName;
                Quantity = quantity;
                UnitPrice = unitPrice;
                TotalPrice = totalPrice;
                Status = status;
                PaymentMethod = paymentMethod;
                DeliveryTime = deliveryTime;
                ShipDate = shipDate;
                ShipAddress = shipAddress;
                ShipPostalCode = shipPostalCode;
                ShipRegion = shipRegion;
                CustomerName = customerName;
                CustomerPhone = customerPhone;
                CustomerEmail = customerEmail;
                CustomerCompany = customerCompany;
                EmployeeName = employeeName;
                EmployeePosition = employeePosition;
                Department = department;
                Warehouse = warehouse;
                ProductCategory = productCategory;
                ProductSupplier = productSupplier;
                ProductSku = productSku;
                ProductBarCode = productBarCode;

                PromoCode = promoCode;
                Discount = discount;
                ShippingMethod = shippingMethod;
                IsGift = isGift;
                GiftMessage = giftMessage;
                EstimatedDeliveryDate = estimatedDeliveryDate;
                TaxType = taxType;
                TaxAmount = taxAmount;
                InvoiceNumber = invoiceNumber;
                InvoiceDate = invoiceDate;
                Currency = currency;
                CustomerLoyaltyLevel = customerLoyaltyLevel;
                RewardPointsUsed = rewardPointsUsed;
                IsSubscription = isSubscription;
                SubscriptionDuration = subscriptionDuration;
                SubscriptionStatus = subscriptionStatus;
                SubscriptionType = subscriptionType;
                ReferralSource = referralSource;
                OrderNotes = orderNotes;
                PackagingType = packagingType;
                RequiresAssembly = requiresAssembly;
                ReturnPolicy = returnPolicy;
                SupplierContact = supplierContact;
                OrderChannel = orderChannel;
                DeliveryInstructions = deliveryInstructions;
                ExpeditedShipping = expeditedShipping;
                BackOrder = backOrder;
                FulfillmentCenter = fulfillmentCenter;
                IsWholesale = isWholesale;
            }

            public static List<Orders> getAllRecords()
            {
                if (order.Count == 0)
                {
                    int code = 10000;
                    for (int i = 1; i <= 5000; i++)
                    {
                        if (i % 2 == 0)
                        {
                            order.Add(new Orders(
                                code + 1, "CUST" + i, i, 2.3 * i, DateTime.Now.AddDays(-i), "City" + i, "Country" + i, i % 2 == 0,
                                "Product" + i, i * 10, 15.5, i * 10 * 15.5, "Status" + i, "Payment" + i, "DeliveryTime" + i, DateTime.Now.AddDays(i),
                                "Address" + i, "Postal" + i, "Region" + i, "Name" + i, "Phone" + i, "Email" + i + "@example.com", "Company" + i,
                                "Employee" + i, "Position" + i, "Department" + i, "Warehouse" + i, "Category" + i, "Supplier" + i, "SKU" + i, "BarCode" + i,
                                "PROMO" + i, i * 0.5, "Express", i % 2 == 0, "Happy Birthday!", DateTime.Now.AddDays(i + 5),
                                "VAT", i * 1.5, "INV-" + i, DateTime.Now.AddDays(-i + 1), "USD", "Gold", i * 10, i % 2 == 0,
                                i % 12, "Active", "Monthly", "Website", "Urgent order", "Box", i % 3 == 0, "30-day return", "Supplier Contact " + i,
                                "Online", "Leave at door", i % 2 == 0, i % 5 == 0, "Fulfillment Center " + i, i % 4 == 0));
                        }
                        else
                        {
                            order.Add(new Orders(
                                code + 1, "CUST" + 1, i, 2.3 * i, DateTime.Now.AddDays(-i), "City" + i, "Country" + i, i % 2 == 0,
                                "Product" + i, i * 10, 15.5, i * 10 * 15.5, "Status" + i, "Payment" + i, "DeliveryTime" + i, DateTime.Now.AddDays(i),
                                "Address" + i, "Postal" + i, "Region" + i, "Name" + i, "Phone" + i, "Email" + i + "@example.com", "Company" + i,
                                "Employee" + i, "Position" + i, "Department" + i, "Warehouse" + i, "Category" + i, "Supplier" + i, "SKU" + i, "BarCode" + i,
                                "PROMO" + i, i * 0.5, "Express", i % 2 == 0, "Happy Birthday!", DateTime.Now.AddDays(i + 5),
                                "VAT", i * 1.5, "INV-" + i, DateTime.Now.AddDays(-i + 1), "USD", "Gold", i * 10, i % 2 == 0,
                                i % 12, "Active", "Monthly", "Website", "Urgent order", "Box", i % 3 == 0, "30-day return", "Supplier Contact " + i,
                                "Online", "Leave at door", i % 2 == 0, i % 5 == 0, "Fulfillment Center " + i, i % 4 == 0));
                        }
                        code += 1;
                    }
                }
                return order;
            }

            public long OrderID { get; set; }
            [Required]
            public string CustomerID { get; set; }
            public int EmployeeID { get; set; }
            public double Freight { get; set; }
            public DateTime OrderDate { get; set; }
            public string ShipCity { get; set; }
            public string ShipCountry { get; set; }
            public bool Checked { get; set; }

            // Existing fields
            public string ProductName { get; set; }
            public int Quantity { get; set; }
            public double UnitPrice { get; set; }
            public double TotalPrice { get; set; }
            public string Status { get; set; }
            public string PaymentMethod { get; set; }
            public string DeliveryTime { get; set; }
            public DateTime ShipDate { get; set; }
            public string ShipAddress { get; set; }
            public string ShipPostalCode { get; set; }
            public string ShipRegion { get; set; }
            public string CustomerName { get; set; }
            public string CustomerPhone { get; set; }
            public string CustomerEmail { get; set; }
            public string CustomerCompany { get; set; }
            public string EmployeeName { get; set; }
            public string EmployeePosition { get; set; }
            public string Department { get; set; }
            public string Warehouse { get; set; }
            public string ProductCategory { get; set; }
            public string ProductSupplier { get; set; }
            public string ProductSku { get; set; }
            public string ProductBarCode { get; set; }

            // New fields
            public string PromoCode { get; set; }
            public double Discount { get; set; }
            public string ShippingMethod { get; set; }
            public bool IsGift { get; set; }
            public string GiftMessage { get; set; }
            public DateTime EstimatedDeliveryDate { get; set; }
            public string TaxType { get; set; }
            public double TaxAmount { get; set; }
            public string InvoiceNumber { get; set; }
            public DateTime InvoiceDate { get; set; }
            public string Currency { get; set; }
            public string CustomerLoyaltyLevel { get; set; }
            public double RewardPointsUsed { get; set; }
            public bool IsSubscription { get; set; }
            public int SubscriptionDuration { get; set; }
            public string SubscriptionStatus { get; set; }
            public string SubscriptionType { get; set; }
            public string ReferralSource { get; set; }
            public string OrderNotes { get; set; }
            public string PackagingType { get; set; }
            public bool RequiresAssembly { get; set; }
            public string ReturnPolicy { get; set; }
            public string SupplierContact { get; set; }
            public string OrderChannel { get; set; }
            public string DeliveryInstructions { get; set; }
            public bool ExpeditedShipping { get; set; }
            public bool BackOrder { get; set; }
            public string FulfillmentCenter { get; set; }
            public bool IsWholesale { get; set; }

            private static List<Orders> order = new List<Orders>();
        }
        public class Movements
        {
            public Movements() { }
            public Movements(int id, DateTime date, string type, string product, decimal quantity, string location, string status)
            {
                ID = id;
                Date = date;
                Type = type;
                Product = product;
                Quantity = quantity;
                Location = location;
                Status = status;
            }
            public static List<Movements> getAllRecords()
            {
                List<Movements> movements = new List<Movements>();
                movements.Add(new Movements(1, new DateTime(2025 ,01 ,01), "Stock In", "Product 1", 10.5m, "Location 1", "Completed"));
                movements.Add(new Movements(2, new DateTime(2025, 01, 01), "Stock Out", "Product 2", -20.75m, "Location 2", "Completed"));
                movements.Add(new Movements(3, new DateTime(2025, 01, 01), "Stock In", "Product 3", 30.00m, "Location 3", "Completed"));
                movements.Add(new Movements(4, new DateTime(2025, 01, 02), "Stock Out", "Product 4", -40.70m, "Location 4", "Completed"));
                movements.Add(new Movements(5, new DateTime(2025, 01, 03), "Stock In", "Product 5", 50.22m, "Location 5", "Completed"));
                movements.Add(new Movements(6, new DateTime(2025, 01, 03), "Stock Out", "Product 6", -60.05m, "Location 6", "Completed"));
                movements.Add(new Movements(7, new DateTime(2025, 01, 04), "Stock In", "Product 7", 70.55m, "Location 7", "Completed"));
                movements.Add(new Movements(8, new DateTime(2025, 01, 04), "Stock Out", "Product 8", -80.11m, "Location 8", "Completed"));
                movements.Add(new Movements(9, new DateTime(2025, 01, 04), "Stock In", "Product 9", 90.00m, "Location 9", "Completed"));
                movements.Add(new Movements(10, new DateTime(2025, 01, 05), "Stock In", "Product 10", 100.01m, "Location 10", "Completed"));
                movements.Add(new Movements(11, new DateTime(2025, 01, 05), "Stock Out", "Product 10", -100.25m, "Location 10", "Completed"));
                movements.Add(new Movements(12, new DateTime(2025, 01, 05), "Stock In", "Product 10", 100.13m, "Location 10", "Completed"));
                movements.Add(new Movements(13, new DateTime(2025, 01, 06), "Stock In", "Product 10", 100.15m, "Location 10", "Completed"));
                movements.Add(new Movements(14, new DateTime(2025, 01, 06), "Stock In", "Product 10", 100.11m, "Location 10", "Completed"));
                movements.Add(new Movements(15, new DateTime(2025, 01, 06), "Stock Out", "Product 10", -100.55m, "Location 10", "Completed"));
                movements.Add(new Movements(16, new DateTime(2025, 01, 07), "Stock In", "Product 10", 100.50m, "Location 10", "Completed"));
                movements.Add(new Movements(17, new DateTime(2025, 01, 07), "Stock In", "Product 10", 100.58m, "Location 10", "Completed"));
                movements.Add(new Movements(18, new DateTime(2025, 01, 08), "Stock Out", "Product 10", -100.22m, "Location 10", "Completed"));
                movements.Add(new Movements(19, new DateTime(2025, 01, 09), "Stock In", "Product 10", 100.60m, "Location 10", "Completed"));
                movements.Add(new Movements(20, new DateTime(2025, 01, 10), "Stock In", "Product 10", 100.65m, "Location 10", "Completed"));
                movements.Add(new Movements(21, new DateTime(2025, 01, 10), "Stock Out", "Product 10", -100.78m, "Location 10", "Completed"));
                movements.Add(new Movements(22, new DateTime(2025, 01, 11), "Stock In", "Product 10", 100.30m, "Location 10", "Completed"));
                movements.Add(new Movements(23, new DateTime(2025, 01, 12), "Stock In", "Product 10", 100.50m, "Location 10", "Completed"));

                return movements;
            }
            public int ID { get; set; }
            public DateTime Date { get; set; }
            public string Type { get; set; }
            public string Product { get; set; }
            public decimal Quantity { get; set; }
            public string Location { get; set; }
            public string Status { get; set; }
        }
    }
}
