import { CommonModule } from '@angular/common';
import { Component, OnInit, ViewChild, HostListener } from '@angular/core';
import { GridAllModule, GroupSettingsModel } from '@syncfusion/ej2-angular-grids';

import { PageSettingsModel, Page, Sort,Group, Filter, Edit, DataStateChangeEventArgs, DataSourceChangedEventArgs, GridComponent, SortService, FilterService, CommandColumnService, SearchService, ColumnChooser, isComplexField } from '@syncfusion/ej2-angular-grids';
import { EditService, ToolbarService, PageService } from '@syncfusion/ej2-angular-grids';


import {datasource, virtualData} from './datasource'
@Component({
  selector: 'app-root',
  templateUrl: 'app.component.html',
  styleUrl: 'app.component.scss',
  standalone: true,
  imports: [
    CommonModule,
    GridAllModule,

  ],
  providers: [ToolbarService, SortService, EditService, FilterService, PageService, CommandColumnService, SearchService]
})
export class AppComponent {
  public vData: Object[] = [];
  @ViewChild('grid')
  public grid?: GridComponent;
  public pageSettings: object = { pageSize: 50 };
  public groupSettings: GroupSettingsModel = { columns: ['FIELD3'],showDropArea:false, enableLazyLoading: false };
  resizeSettings = { mode: 'Auto' };
  tabToolbar = [
    { text: '', tooltipText: 'Download Excel', prefixIcon: 'e-export-excel', id: 'exportExcel', align: 'Right' },
    { text: '', tooltipText: 'Download CSV', prefixIcon: 'e-export-csv', id: 'exportCSV', align: 'Right' },
    'ColumnChooser'
  ];
  gridHeight: number= 0;
  public commands:any
  public ngOnInit(): void {
    this.onResize();
    datasource();
    this.commands = [{ type: 'Edit', buttonOption: { iconCss: ' e-icons e-edit', cssClass: 'e-flat' } },
      { type: 'Delete', buttonOption: { iconCss: 'e-icons e-delete', cssClass: 'e-flat' } },
      { type: 'Save', buttonOption: { iconCss: 'e-icons e-update', cssClass: 'e-flat' } },
      { type: 'Cancel', buttonOption: { iconCss: 'e-icons e-cancel-icon', cssClass: 'e-flat' } }];
    this.vData = virtualData.slice(0, 1000);
  }

  @HostListener('window:resize', ['$event'])
  onResize(): void {
    this.gridHeight = window.innerHeight||700 - 570;
  }
}
