﻿using System.Diagnostics.CodeAnalysis;

namespace BlazorWebApp.Client;

public class UserListItem : IEqualityComparer<UserListItem>
{
    public UserListItem()
    {        
    }

    public UserListItem(UserListItem source)
    {
        Id = source.Id;
        FullName = source.FullName;
    }

    public int Id { get; set; }

    public string FullName { get; set; } = string.Empty;

    public bool Equals(UserListItem? x, UserListItem? y)
    {
        return x?.Id == y?.Id;
    }

    public int GetHashCode([DisallowNull] UserListItem obj)
    {
        return Id.GetHashCode();
    }
}
