﻿using System.ComponentModel.DataAnnotations;

namespace BlazorWebApp.Client;

public class FormModel
{
    [Required(ErrorMessage = "Title is required")]
    [MaxLength(50, ErrorMessage = "Title is too long")]
    public string Title { get; set; } = string.Empty;

    [Required(ErrorMessage = "Rich Text is required")]
    [MaxLength(100, ErrorMessage = "Rich Text is too long")]
    public string RichText { get; set; } = string.Empty;

    [Required(ErrorMessage = "Text is required")]
    [MaxLength(100, ErrorMessage = "Text is too long")]
    public string Text { get; set; } = string.Empty;

    [Required(ErrorMessage = "You must select user A.")]
    public UserListItem? UserA { get; set; }

    [Required(ErrorMessage = "You must select user B.")]
    public UserListItem? UserB { get; set; }
}
