#region Copyright Syncfusion Inc. 2001-2019.
// Copyright Syncfusion Inc. 2001-2019. All rights reserved.
// Use of this code is subject to the terms of our license.
// A copy of the current license can be obtained at any time by e-mailing
// licensing@syncfusion.com. Any infringement will be prosecuted under
// applicable laws. 
#endregion
using Syncfusion.Windows.Forms;
using Syncfusion.Windows.Forms.Tools;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Syncfusion.WinForms.Controls;
using Syncfusion.Windows.Forms.Tools.XPMenus;

namespace SpellCheckerAdv_2012
{
    public partial class Form1 : SfForm
    {
        TextBoxSpellEditor TextEditor;
        ContextMenuStrip textboxcontextmenu = new ContextMenuStrip();
        public Form1()
        {
            InitializeComponent();
            this.StartPosition = FormStartPosition.CenterScreen;
            this.spellCheckerAdv1.VisualStyle = SpellCheckerAdvStyle.Office2016Colorful;
            this.spellCheckerAdv1.IgnoreSpecialSymbols = true;
            TextEditor = new TextBoxSpellEditor(this.textBoxExt1);
            SpellEditor = TextEditor;
            this.spellCheckerAdv1.PerformSpellCheckForControl(SpellEditor);
            this.textBoxExt1.ContextMenuStrip = textboxcontextmenu;
            this.Load += new EventHandler(Form1_Load);
            this.spellCheckerAdv1.Culture = new System.Globalization.CultureInfo("en-AU");
            this.spellCheckerAdv1.IgnoreSpecialSymbols = true;
        }
            

        #region [IconFile]
        private string GetIconFile(string bitmapName)
        {
            for (int n = 0; n < 10; n++)
            {
                if (System.IO.File.Exists(bitmapName))
                    return bitmapName;

                bitmapName = @"..\" + bitmapName;
            }

            return bitmapName;
        }
        #endregion

        /// <summary>
        /// Gets or sets the ISpellCheckerAdvEditorTools interface.
        /// </summary>
        public ISpellCheckerAdvEditorTools SpellEditor
        {
            get;
            set;
        }

        #region[Events]

        void Form1_Load(object sender, EventArgs e)
        {
            this.textBoxExt1.HideSelection = true;
        }


        #endregion

        private void buttonAdv1_Click(object sender, EventArgs e)
        {
            this.spellCheckerAdv1.SpellCheck(new SpellCheckerAdvEditorWrapper(this.textBoxExt1));
        }
    }
}
