﻿//
using System.Linq.Expressions;
using Microsoft.AspNetCore.Components;
using Syncfusion.Blazor.DropDowns;
using Syncfusion.Blazor.Inputs;

namespace TestLinfoV3Blazor.LcogItems.BlazorControls.LcogDropDownList
{

	public	partial	class	LcogDropDownList
		#region Type arguments
		<
				TValue
			,	TItem
		>
		#endregion
		:		Microsoft.AspNetCore.Components.ComponentBase
	{

		#region Properties - Internal
		private	SfDropDownList < TValue , TItem >		_TheSfDropDownList;
		private	TValue									_Value;
		#endregion

		#region Properties - External
		#region Parameters
		[Parameter]
		public	bool									ShowLeftText										{ get; set; }					= false;
		[Parameter]
		public	string									ID													{ get; set; }					= null;
		[Parameter]
		public	IEnumerable < TItem >					DataSource											{ get; set; }					= null;
		[Parameter]
		public	FloatLabelType							FloatLabelType										{ get; set; }
		[Parameter]
		public	string									Placeholder											{ get; set; }					= null;
		[Parameter]
		public	bool									ShowClearButton										{ get; set; }					= false;
		[Parameter]
		public	string									TheLeftText											{ get; set; }					= null;
		[Parameter]
		public	string									DDLFSValue											{ get; set; }
		[Parameter]
		public	string									DDLFSText											{ get; set; }
		[Parameter]
		#pragma warning disable BL0007
		public	TValue									Value
		{
			get
			{
				return ( this._Value );
			}
			set
			{
				if (!EqualityComparer<TValue>.Default.Equals ( value , this._Value ) )
				{
					this._Value = value;
					ValueChanged.InvokeAsync(value);
				}
			}
		}
		#pragma warning restore BL0007
		[Parameter]
		public	RenderFragment 							DropDownListFieldSettingsFragment					{ get; set; }		= null;
		[Parameter]
		public	EventCallback < TValue >				ValueChanged										{ get; set; }
		[Parameter]
		public Expression < Func < TValue > >			ValueExpression										{ get; set; }
		#endregion
		#endregion

		#region Constructors
		public LcogDropDownList			( )
		{

		}
		#endregion

		#region OnInitializedAsync
		protected override async Task OnInitializedAsync ( )
		{
			//
			await base.OnInitializedAsync ( );
		}
		#endregion

		#region OnParametersSetAsync
		protected	override	async	Task	OnParametersSetAsync	( )
		{
			//
			await base.OnParametersSetAsync ( );
			//
			//this.SetLcogStringValueNoNotif ( this.LcogTextBoxValue );
		}
		#endregion

		#region OnAfterRenderAsync
		protected	override	async	Task	OnAfterRenderAsync	( bool aib_FirstRender )
		{
			//
			await base.OnAfterRenderAsync ( aib_FirstRender );
		}
		#endregion

	}

}
