﻿//
using Syncfusion.Blazor.Grids;
using Syncfusion.Blazor.Popups;
using TestLinfoV3Blazor.LcogItems.LcogObsColl;

namespace TestLinfoV3Blazor.Components.Pages.TestSfGrid
{

	public	partial	class	TestSfGrid
	{

		#region Properties - Internal
		private	SfGrid	< LcogObsItem >				_OurSfGrid;
		private	SfDialog							_OurSfDialog;
		private LcogObsColl							_OurObsColl						{ get; set; }		= new LcogObsColl ( );
		public	bool								IsFromDialogClick				{ get; set; }		= false;
		private	DialogSettings						_OurDialogParams				{ get; set; }		= new DialogSettings { Width = "100%" };
		private	string								_TestLcogTextBoxValue			{ get; set; }
		private	string								_TheDropDownChoiceTheySelected	{ get; set; }
		private	string								_TestLcogTextBoxValue_2			{ get; set; }
		private	Nullable < DateTime >				_TestLcogDateTimeValue			{ get; set; }
		#endregion

		#region OnInitializedAsync
		protected override async Task OnInitializedAsync ( )
		{
			//
			await base.OnInitializedAsync ( );
		}
		#endregion

		#region OnParametersSetAsync
		protected	override	async	Task	OnParametersSetAsync	( )
		{
			//
			await base.OnParametersSetAsync ( );
			//
			await this.LoadData ( );
		}
		#endregion

		#region OnAfterRenderAsync
		protected override async Task OnAfterRenderAsync ( bool aib_FirstRender )
		{
			//
			await base.OnAfterRenderAsync ( aib_FirstRender );
		}
		#endregion

		#region LoadData
		private async Task LoadData ( )
		{
			// Declare variables.
			Task 									ltsk_LoadPrimaryData		= null;
			List < Task >							lltsk_DataLoadTasks			= new List < Task > ( );
			// Catch exceptions.
			try
			{
				// Get our bearer token.
				// We always need to get the main data.
				ltsk_LoadPrimaryData		= this.GetFakeData ( 5 );
				lltsk_DataLoadTasks.Add ( ltsk_LoadPrimaryData );
				// Wait for all the tasks to complete.
				await Task.WhenAll ( lltsk_DataLoadTasks.ToArray ( ) );
				// Check for any faults.
				foreach ( Task lo_Loop_CurrTask in lltsk_DataLoadTasks )
				{
					if ( lo_Loop_CurrTask.IsFaulted )
					{
						System.Diagnostics.Debugger.Break ( );
					}
				}
			}
			catch ( System.Exception lo_SE )
			{
				//
				System.Diagnostics.Debugger.Break ();
				//
				throw ( new System.Exception ( "test" , lo_SE ) );
			}
		}
		#endregion

		#region GetFakeData
		private async Task GetFakeData ( int aii_NumToAdd )
		{
			// Declare variables.
			LcogObsItem				lo_LOI;
			// Catch exceptions.
			try
			{
				//
				this._OurObsColl.Clear ( );
				//
				for ( int li_LoopIdx = 0 ; li_LoopIdx <  aii_NumToAdd ; li_LoopIdx++ )
				{
					//
					lo_LOI				= new LcogObsItem ( );
					lo_LOI.TheCode		= li_LoopIdx.ToString ( );
					lo_LOI.TheName		= $"The Name is {li_LoopIdx}.";
					lo_LOI.TheDecimal	= (decimal?) 10.5;
					//
					this._OurObsColl.Add ( lo_LOI );
				}
			}
			catch ( System.Exception lo_SE )
			{
				System.Diagnostics.Debugger.Break ( );
				//
				throw (new System.Exception ( "test" , lo_SE ));
			}
			//
			await Task.FromResult < bool > ( false );
		}
		#endregion

		#region RowUpdating
		private async Task RowUpdating ( RowUpdatingEventArgs<LcogObsItem> args )
		{
			//if (args.Data.TheName != args.PreviousData.TheName)
			//{
			//	args.Cancel = true; // This will prevent update operation
			//}
			//
			await Task.FromResult<bool> ( false );
		}
		#endregion

		#region RowDeleting
		private async Task RowDeleting ( RowDeletingEventArgs<LcogObsItem> args )
		{
			args.Cancel = true; // This will prevent Delete operation
			//
			await Task.FromResult<bool> ( false );
		}
		#endregion

		#region DataBoundHandler
		public void DataBoundHandler ( BeforeDataBoundArgs<LcogObsItem> args )
		{
			//Grid.Columns [ 0 ].IsPrimaryKey = true;
			var lo_Thomas		= this._OurSfGrid.Columns [ 0 ].IsPrimaryKey;
		}
		#endregion

		#region OurEditRequestedCancelingHandler
		public async Task OurEditRequestedCancelingHandler ( EditCancelingEventArgs < LcogObsItem > args )
		{
			//Grid.Columns [ 0 ].IsPrimaryKey = true;
			var lo_Thomas		= this._OurSfGrid.Columns [ 0 ].IsPrimaryKey;
			//
			// Here we can compare args.Data to args.PreviousData.
			//
			// But how do we ask the user if they really want to cancel out of the Edit Dialog window?
			//
			if (!IsFromDialogClick)
			{
				args.Cancel = true;

				await this._OurSfDialog.ShowAsync();
			}
		}
		#endregion

		private async Task DialogOkClick ( )
		{
			await this._OurSfDialog.HideAsync ( );
			IsFromDialogClick = true;
			await this._OurSfGrid.CloseEditAsync ( ); // Close the edit dialog without saving changes
			IsFromDialogClick = false;

		}
		private async Task DialogCancelClick ( )
		{
			await this._OurSfDialog.HideAsync ( );
		}



	}

}
