﻿using System.Linq;
using System;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using BlazorDataGridSQLNet8.Data;

namespace BlazorDataGridSQLNet8.Data
{
   public class DataGridService
   {
         OrderContext db=new OrderContext();
		 
     
		public async Task<IQueryable<Order>> GetAllOrderAsync()
		{
			try
			{
				return db.Orders.AsQueryable(); // Return IQueryable for async querying
			}
			catch
			{
				throw;
			}
		}

		// To Add new Data record
		public async Task AddOrderAsync(Order data)
		{
			try
			{
				await db.Orders.AddAsync(data); // Use AddAsync for adding records
				await db.SaveChangesAsync(); // Use SaveChangesAsync for saving changes
			}
			catch
			{
				throw;
			}
		}

		//To Update the records of a particluar Data    
		public void UpdateOrder(Order Data)
        {
            try
            {
                var data = db.Orders.Where(x => x.OrderID == Data.OrderID).SingleOrDefault();
                data!.OrderID=Data.OrderID;
                data!.CustomerID=Data.CustomerID;
                data!.EmployeeID=Data.EmployeeID;
                data!.ShipCountry=Data.ShipCountry;
                data!.ShipAddress=Data.ShipAddress;
                data!.ShipName=Data.ShipName;
                data!.ShipCity=Data.ShipCity;
		   
			  
               db.SaveChanges();
            }
            catch
            {
                throw;
            }
        }

        //To Delete the record of a particular Data
         public void DeleteOrder(int value)
         {
           try
           {
             Order? data = db.Orders.Find(value);
            db.Orders.Remove(data!);
            db.SaveChanges();
           }
           catch
           {
             throw;
            }
          }

        //Get the details of a particular Data    
        public Order GetOrderData(int id)
        {
            try
            {
                Order? Data = db.Orders.Find(id);
                return Data!;
            }
            catch
            {
                throw;
            }
        }
    }
   
}