using Microsoft.Maui.Graphics.Platform;
using System.Diagnostics;

namespace SyncMAUI;

public partial class InputView : ContentView
{
    private InputViewModel viewModel;
	public InputView()
	{
		InitializeComponent();
        this.Loaded += InputView_Loaded;
        this.BindingContext = viewModel = new InputViewModel();
        App.Current.RequestedThemeChanged += Current_RequestedThemeChanged;
        LightThemeUri = new Uri("../Resources/Styles/LightTheme.xaml",UriKind.Relative);
	}

    private string resourceDictionaryKey = "buttonColorDictionary";

    private void InputView_Loaded(object? sender, EventArgs e)
    {
        DarkThemeUri = (this.Resources.MergedDictionaries.OfType<ResourceDictionary>().FirstOrDefault()).Source;
    }

    public Uri DarkThemeUri { get; set; }
    public Uri LightThemeUri { get; set; }
    private void OnCounterClicked(object sender, EventArgs e)
    {
        App.Current.UserAppTheme = App.Current.RequestedTheme == AppTheme.Dark ? AppTheme.Light : AppTheme.Dark;
    }

    private void Current_RequestedThemeChanged(object? sender, AppThemeChangedEventArgs e)
    {
        //this.Resources.MergedDictionaries.Clear();
        //this.Resources.MergedDictionaries.Add(e.RequestedTheme == AppTheme.Light? new SyncMAUI.Resources.Styles.LightTheme(): new SyncMAUI.Resources.Styles.DarkTheme());
    }

    private void Button_Clicked(object sender, EventArgs e)
    {
        hostGrid.WidthRequest = hostGrid.Width + 50;
    }
        

    private double CheckArrowSize(string arrowText)
    {
        IStringSizeService stringSizeService = new PlatformStringSizeService();

        Microsoft.Maui.Graphics.Font font = new("Times New Roman");
        Size stringSize = stringSizeService.GetStringSize(arrowText, font, 14F);
        
        return stringSize.Width;
    }

    private void hostGrid_SizeChanged(object sender, EventArgs e)
    {
        string arrow = "+";
        Debug.WriteLine($"Grid <-----> Width:{hostGrid.Width}");
        double arrowSize = 0;
        while (hostGrid.Width > CheckArrowSize(arrow))
        {
            arrowSize = CheckArrowSize(arrow);
            Debug.WriteLine($"String <-----> Width:{arrowSize}");
            arrow += "+";
        }
     
        viewModel.GridWidth = hostGrid.Width;
        viewModel.StringWidth = arrowSize;

        arrowHead.Text = arrow;
    }

    private void Button_Clicked_1(object sender, EventArgs e)
    {
        if (this.hostGrid.Width > 25)
        {
            this.hostGrid.WidthRequest = this.hostGrid.Width - 25;
        }
    }
}