/// Packages import
import 'package:flutter/material.dart';

/// DataGrid import
// ignore: depend_on_referenced_packages
import 'package:syncfusion_flutter_datagrid/datagrid.dart';

/// Local import
import '../datagridsource/orderinfo_datagridsource.dart';

class MyInfiniteGrid extends StatefulWidget {
  const MyInfiniteGrid({super.key});

  @override
  State<MyInfiniteGrid> createState() => _MyInfiniteGridState();
}

class _MyInfiniteGridState extends State<MyInfiniteGrid> {
  late OrderInfoDataGridSource _employeeDataSource;

  /// Building the progress indicator when DataGrid scroller reach the bottom
  Widget _buildProgressIndicator() {
    return Container(
        height: 60.0,
        alignment: Alignment.center,
        width: double.infinity,
        decoration: BoxDecoration(color: Colors.red, border: BorderDirectional(top: BorderSide(color: Colors.red))),
        child: Container(
            width: 40,
            height: 40,
            alignment: Alignment.center,
            child: CircularProgressIndicator(
              valueColor: AlwaysStoppedAnimation<Color?>(Colors.blue),
              backgroundColor: Colors.transparent,
            )));
  }

  /// Callback method for load more builder
  Widget _buildLoadMoreView(BuildContext context, LoadMoreRows loadMoreRows) {
    Future<String> loadRows() async {
      // Call the loadMoreRows function to call the
      // DataGridSource.handleLoadMoreRows method. So, additional
      // rows can be added from handleLoadMoreRows method.
      await loadMoreRows();
      return Future<String>.value('Completed');
    }

    return FutureBuilder<String>(
      initialData: 'Loading',
      future: loadRows(),
      builder: (BuildContext context, AsyncSnapshot<String> snapShot) {
        return snapShot.data == 'Loading' ? _buildProgressIndicator() : SizedBox.fromSize(size: Size.zero);
      },
    );
  }

  @override
  void initState() {
    super.initState();

    _employeeDataSource = OrderInfoDataGridSource(orderDataCount: 25);
  }

  @override
  Widget build(BuildContext context) {
    return SfDataGrid(
      source: _employeeDataSource,
      loadMoreViewBuilder: _buildLoadMoreView,
      columns: _obtainColumns(),
    );
  }

  List<GridColumn> _obtainColumns() {
    return <GridColumn>[
      GridColumn(
          columnName: 'id',
          // width: (_isWebOrDesktop && model.isMobileResolution) ? 120 : double.nan,
          columnWidthMode: ColumnWidthMode.fill,
          label: Container(
              padding: const EdgeInsets.all(8),
              alignment: Alignment.centerRight,
              child: const Text(
                'Order ID',
                overflow: TextOverflow.ellipsis,
              ))),
      GridColumn(
          columnName: 'customerId',
          columnWidthMode: ColumnWidthMode.fill,
          // width: !_isWebOrDesktop
          //     ? 120
          //     : (_isWebOrDesktop && model.isMobileResolution)
          //         ? 150
          //         : double.nan,
          label: Container(
              padding: const EdgeInsets.all(8),
              alignment: Alignment.centerRight,
              child: const Text(
                'Customer ID',
                overflow: TextOverflow.ellipsis,
              ))),
      GridColumn(
          columnName: 'name',
          // width: (_isWebOrDesktop && model.isMobileResolution) ? 120 : double.nan,
          label: Container(
              padding: const EdgeInsets.all(8),
              alignment: Alignment.centerLeft,
              child: const Text(
                'Name',
                overflow: TextOverflow.ellipsis,
              ))),
      GridColumn(
          // width: (_isWebOrDesktop && model.isMobileResolution) ? 110 : double.nan,
          columnName: 'freight',
          label: Container(
              padding: const EdgeInsets.all(8),
              alignment: Alignment.centerRight,
              child: const Text(
                'Freight',
                overflow: TextOverflow.ellipsis,
              ))),
      GridColumn(
          columnName: 'city',
          // width: (_isWebOrDesktop ) ? 120 : double.nan,
          columnWidthMode: ColumnWidthMode.fill,
          label: Container(
              padding: const EdgeInsets.all(8),
              alignment: Alignment.centerLeft,
              child: const Text(
                'City',
                overflow: TextOverflow.ellipsis,
              ))),
      GridColumn(
          width: double.nan,
          columnName: 'price',
          columnWidthMode: ColumnWidthMode.lastColumnFill,
          label: Container(
              padding: const EdgeInsets.all(8),
              alignment: Alignment.centerRight,
              child: const Text(
                'Price',
                overflow: TextOverflow.ellipsis,
              )))
    ];
  }
}
