import { Gantt, Toolbar, Selection } from '@syncfusion/ej2-gantt';
// Registering Syncfusion license key
import { registerLicense } from "@syncfusion/ej2-base";

import { zoomingData1 } from './data';

registerLicense(
    "ORg4AjUWIQA/Gnt2XVhhQlJHfV5AQmBIYVp/TGpJfl96cVxMZVVBJAtUQF1hTX9RdEdiUXpdcH1cQ2RV"
  );


/**
 * Zooming Gantt sample
 */
console.log("gotcha")
Gantt.Inject(Toolbar,Selection);
let gantt_fail:Gantt;
let gantt_ok:Gantt;

const initializeGanttChart = (): void => {
    try {
        console.log("gotcha1")

        gantt_fail = new Gantt(
            {
                dataSource: zoomingData1,
                enableTimelineVirtualization:true,
                height: '300px',
                treeColumnIndex: 1,
                taskFields: {
                    id: 'TaskID',
                    name: 'TaskName',
                    startDate: 'StartDate',
                    endDate: 'EndDate',
                    duration: 'Duration',
                    progress: 'Progress',
                    dependency: 'Predecessor',
                    child: 'subtasks'
                },
                columns: [
                    { field: 'TaskID', width: 80 },
                    { field: 'TaskName', width: 250 },
                    { field: 'StartDate' },
                    { field: 'EndDate' },
                    { field: 'Duration' },
                    { field: 'Predecessor' },
                    { field: 'Progress' },
                ],
                toolbar: [
                    'ZoomIn', 
                    'ZoomOut', 
                    'ZoomToFit',
                    {id:"zoomIn", type:"Button",text:"Zoom In Manual",cssClass:"btn-red", click:() => gantt_fail.zoomIn()},
                    {id:"zoomOut", type:"Button",text:"Zoom Out Manual",cssClass:"btn-red", click:() => gantt_fail.zoomOut()},
                    {id:"zoomToFit", type:"Button",text:"ZoomToFit Manual",cssClass:"btn-red", click:() => gantt_fail.fitToProject()}            
                ],
                labelSettings: {
                    leftLabel: 'TaskName'
                },
                splitterSettings: {
                    position: "35%"
                }
            });
        console.log("gantt-fail",gantt_fail);
        gantt_fail.appendTo('#gantt-zoom-fail');
    
        gantt_ok = new Gantt(
            {
                dataSource: zoomingData1,
                //enableTimelineVirtualization:true,
                height: '300px',
                treeColumnIndex: 1,
                taskFields: {
                    id: 'TaskID',
                    name: 'TaskName',
                    startDate: 'StartDate',
                    endDate: 'EndDate',
                    duration: 'Duration',
                    progress: 'Progress',
                    dependency: 'Predecessor',
                    child: 'subtasks'
                },
                columns: [
                    { field: 'TaskID', width: 80 },
                    { field: 'TaskName', width: 250 },
                    { field: 'StartDate' },
                    { field: 'EndDate' },
                    { field: 'Duration' },
                    { field: 'Predecessor' },
                    { field: 'Progress' },
                ],
                toolbar: [
                    'ZoomIn', 
                    'ZoomOut', 
                    'ZoomToFit',
                    {id:"zoomIn", type:"Button",text:"Zoom In Manual",cssClass:"btn-green", click:() => gantt_ok.zoomIn()},
                    {id:"zoomOut", type:"Button",text:"Zoom Out Manual",cssClass:"btn-green", click:() => gantt_ok.zoomOut()},
                    {id:"zoomToFit", type:"Button",text:"ZoomToFit Manual",cssClass:"btn-green", click:() => gantt_ok.fitToProject()}
                ],
                labelSettings: {
                    leftLabel: 'TaskName'
                },
                splitterSettings: {
                    position: "35%"
                }
            });
            console.log("gantt-ok",gantt_ok);
            gantt_ok.appendTo('#gantt-zoom-ok');

    } catch (error) {
        console.log("error",error)
    }
 
};


// Call the function immediately
initializeGanttChart();

